#! /usr/bin/env lua

-- FileDialog demo

require("lgui")

function runDialog(dialog)
	dialog:run()
	dialog:hide()
	
	local t = lgui.FileChooser.getFilenames(dialog)
	table.foreach(t, print)
end

local window = lgui.Window.new()
local button = lgui.Button.newWithMnemonic("_Show Dialog")
local dialog = lgui.FileChooserDialog.new("Select the file", window, lgui.FILE_CHOOSER_ACTION_OPEN,
"gtk-cancel", lgui.RESPONSE_CANCEL, "gtk-ok", lgui.RESPONSE_OK)


filter = lgui.FileFilter.new()
filter:addPattern("*.lua")
filter:setName("Lua scripts")
lgui.FileChooser.addFilter(dialog, filter)

dialog:set("select-multiple", true)
window:connect("delete-event", lgui.quit)
button:connect("clicked", runDialog, dialog)

window:set("title", "FileDialog demo", "window-position", lgui.WIN_POS_CENTER)
window:add(button)
window:showAll()

lgui.main()
