#! /usr/bin/env lua

-- Entry that only allow numbers!

require("lgui")

local window = lgui.Window.new()
local vbox   = lgui.VBox.new(false, 5)
local label  = lgui.Label.new("Numbers only")
local entry  = lgui.Entry.new()

function keyPressed(data, event)
	print(data, event)
	local etype, state, value = lgui.Event.keyGet(event)
	print(etype, state, value)	
	local num = value - string.byte("0")
	
	if (num >= 0 and num < 10) then
		return false
	else
		return true
	end
end

entry:connect("key-press-event", keyPressed)

vbox:add(label, entry)
window:add(vbox)
window:set("title", "Hello Event", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)

window:showAll()
lgui.main()
