#! /usr/bin/env lua

-- Storing data in the objects

-- Importing the library
require("lgui")

-- Callback functions
function hello(obj)
	local mt = getmetatable(obj)
	print(mt.msg)
end

-- Create the widgets
local window = lgui.Window.new()
local button = lgui.Button.new()

-- Set some properties
button:set("label", "Click me!")
window:add(button)

-- Syntactic sugar for setting more than one property
window:set("title", "Hello World", "window-position", lgui.WIN_POS_CENTER)

-- Set the data fo future use
getmetatable(button).msg = "Hello data!"

-- Connect the callbacks
window:connect("delete-event", lgui.quit)
button:connect("clicked", hello, button)

-- Show 'window' and all the widgets in 'window'
window:showAll()

-- Start the main loop
lgui.main()
