#! /usr/bin/env lua

-- Widget cursors

require("lgui")

local list = {
	lgui.GDK_X_CURSOR, lgui.GDK_ARROW, lgui.GDK_CROSS,
	lgui.GDK_FLEUR, lgui.GDK_HAND1, lgui.GDK_HAND2, lgui.GDK_LEFT_PTR,
	lgui.GDK_PENCIL, lgui.GDK_QUESTION, lgui.GDK_RIGHT_PTR, lgui.GDK_XTERM,
	lgui.GDK_WATCH
}

local window, gdkw = lgui.Window.new()
local cur = 0

function change()
	cur = cur + 1
	if not list[cur] then cur = 1 end
	gdkw:setCursor(lgui.Cursor.new(list[cur]))
	return true
end

window:set("title", "Cursor example", "window-position", lgui.WIN_POS_CENTER)
window:connect("delete-event", lgui.quit)
window:showAll()
gdkw = window:get("window"):cast(lgui.GdkWindow)

-- Keep changing the cursor
lobj.Timeout.add(lobj.PRIORITY_DEFAULT, 1000, change)

lgui.main()
