#! /usr/bin/env lua

--[[
	Clipboard example.
--]]

require("lgui")

-- Getting the shared clipboard
local clip = lgui.Clipboard.get(lgui.Atom.intern("CLIPBOARD"))
local buff = lgui.Pixbuf.newFromFile("icon.png")

-- UI
local window = lgui.Window.new()

local button = lgui.Button.newWithMnemonic("Click to test!") 
button:connect("clicked", 
	function()
			clip:setText("Text from " .. arg[0])
			print(clip:getText())
			clip:setImage(buff)
			print(clip:getImage())
	end)

window:add(button)
window:set("window-position", lgui.WIN_POS_CENTER, "title", "Clipboard example")
window:connect("delete-event", lgui.quit)
window:showAll()

lgui.main()
