#! /usr/bin/env lua

-- Assistant example

require("lgui")

local assist = lgui.Assistant.new()
local page1, page2 = lgui.VBox.new(true, 10), lgui.VBox.new(true, 10)

page1:add(lgui.Label.new("First line of page 1!"), lgui.Label.new("Yeah!"))
page2:add(lgui.Label.new("First line of page 2!"), lgui.Label.new("Yeah!"))

assist:add(page1, page2)

assist:childSet(page1, "title", "Page 1", "page-type", lgui.ASSISTANT_PAGE_INTRO, "complete", true)
assist:childSet(page2, "title", "Page 2", "page-type", lgui.ASSISTANT_PAGE_CONFIRM)

assist:set("title", "Hello assistant!", "window-position", lgui.WIN_POS_CENTER)
assist:set("width-request", 400, "height-request", 300)
assist:connect("delete-event", lgui.quit)
assist:connect("cancel", lgui.quit)

assist:showAll()
lgui.main()
