#!/usr/bin/env perl
#
# Adapted by Nick Rapallo (November 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software).  Given a single PowerPoint .ppt full pathname file
# it creates .imp ebook as well as .opf for later use.
# For .IMP for REB 1200, set BuildTarget = 1;
# For the GEB/EBW 1150 set BuildTarget = 2;
# For the REB 1100 set BuildTarget = 3;
# For the OEBFF, set BuildTarget = 0; (this saves/packs the intermediate .tmp PPT file!)

package main;
use strict;
use Cwd 'abs_path';
use Win32::OLE;
use Win32::OLE qw(EVENTS);
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED); 

my $debug = 0;                                              #set to 1 for print messages

###################################################################
#
# get the interfaces, complain and quit if we cannot
#
my $project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

if ($debug) { print "Beginning P...", $project, "\n"; }

my $builder = Win32::OLE->new("SBPublisher.Builder") or 
        die "Unable to get IBuilder interface\n";

if ($debug) { print "Beginning B...", $builder, "\n"; }
 
# Setup the event handling.
#
Win32::OLE->WithEvents($builder, 'EventHandlers');
 
###################################################################
#
# Get our PowerPoint .ppt and have OnBuildStart create a new project and
# add our document file with various "metadata" items for the publication.
#
my $in  = abs_path($ARGV[0]);                               #Requires Full pathname to .doc file!!!
my $out = $ARGV[0].".imp";

###################################################################
#
# Now build the EBW/GEB 1150 (gray HalfVga) .IMP output
# (set TargetDevie to 1 for REB1200; 0 for OEBFF.)
#
$builder->{FirstSlideSeparate} = 0;           # 0=False; 1=True
$builder->{Rotation} = 0;                     # 0=Counter-clockwise (rotate left); 1=Clockwise (rotate right)
$builder->{SlideMode} = 1;                    # 0=OneUp; 1=TwoUp
$builder->{TargetDevice} = 2;
$builder->BuildFromPowerPoint($in, $out);
if (Win32::OLE->LastError() != 0) { 
        print "ERROR: Build method failed.\n";
} else { 
        print "Done!\n";
} 
print "Path to output file: $builder->{OutputFilename} \n"; 
Win32::OLE->Uninitialize(); 
exit;

###################################################################
#
# Event Handlers
#
package EventHandlers;
sub OnBuildStart()
{
	my ($builder, $project, @args) = @_;
	if ($debug) { print "Beginning validation...", " builder: ", $builder, " project: ", $project, " args: ", @args, "\n"; }
        
        $project->{AuthorFirstName} = "Default Author";
        $project->{AuthorLastName} = ".";
        $project->{AuthorMiddleName} = ".";
        $project->{BookFileName} = $ARGV[0];
        $project->{BookID} = "";
        $project->{BookTitle} = "Default Title";
        $project->{BuildTarget} = 2;
        $project->{CSS} = 1;
        $project->{Category} = "Default Category";
        $project->{Compress} = 1;                           #True
        $project->{ContentFeedID} = ".";
        $project->{CurrentIssue} = ".";
        $project->{DeleteFallbacks} = 0;
        $project->{Encrypt} = 0;                            #False
        $project->{ErrorDirectory} = ".";
        $project->{ErrorFeedback} = 0;
        $project->{HasChanged} = 0;
        $project->{Implode} = 1;
        $project->{IsPeriodical} = 0;
        $project->{OrphanLines} = 0;
        $project->{OutputDirectory} = ".";
        $project->{ProjectFile} = "";
        $project->{SubCategory} = ".";
        $project->{UnderlineLinks} = 1;
        $project->{WidowLines} = 0;
        $project->{Zoom} = 2;
        
        $project->Save($ARGV[0].".opf");

# Not allowed here!
#        $project->{AuthorFileAs} = ".";
#        $project->{BISAC} = ".";
#        $project->{ColorCover} = ".";
#        $project->{ColorDepth} = 0;
#        $project->{ConvertToJPEG} = 0;
#        $project->{CopyrightDate} = ".";
#        $project->{CurrencyCodes} = ".";
#        $project->{GlossaryFile} = ".";
#        $project->{GrayCover} = ".";
#        $project->{Grayscale} = 0;
#        $project->{ISBN} = ".";
#        $project->{Imprint} = ".";
#        $project->{InitialContent} = 0;
#        $project->{KeepAnchors} = 0;
#        $project->{Keywords} = ".";
#        $project->{Language} = ".";
#        $project->{LongDescription} = ".";
#        $project->{MediumDescription} = ".";
#        $project->{MonoCover} = ".";
#        $project->{OEBFFProject} = ".";
#        $project->{PreScaleImages} = 0;
#        $project->{PriceBinding} = 0;
#        $project->{PublishDate} = ".";
#        $project->{Publisher} = ".";
#        $project->{ReferringISBN} = ".";
#        $project->{RequireISBN} = 0;
#        $project->{RetailPrices} = ".";
#        $project->{ShortDescription} = ".";
#        $project->{TitleFileAs} = ".";
#        $project->{TradeZones} = ".";

}
