// Copyright (C) 2008 Simon Mendoza
// This file is part of gtk-sudoku.
//
// gtk-sudoku is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// gtk-sudoku is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with gtk-sudoku.  If not, see <http://www.gnu.org/licenses/>.

#include "solver.h"
#include "do.h"

#define M 4
#define M2 M*M
#define M4 M2*M2

static int A0[M2+9][M2+9],A[M2+9][M2+9];
static int Rows[4*M4+9],Cols[M2*M4+9],Row[4*M4+9][M2+9],Col[M2*M4+9][5];
static int Ur[M2*M4+9],Uc[4*M4+9],V[M2*M4+9];
static int C[M4+9],I[M4+9];
static int min,clues;
long long tnodes,solutions,vmax;

static int i,j,k,l,r,r1,c,c1,c2,n,N,N2,N4,m,m0,m1,x,y,s;
static char L[66]=".123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz#*~";

bool mark_incorrect_squares(void)
{
	register int row;
	register int col;
	const char *strval;
	char value_f[50];
	bool at_least_one_incorrect = false;

	for(row = 0; row < GRID_SIZE; ++row)
	for(col = 0; col < GRID_SIZE; ++col) {
		if(sudoku.square[row][col].editable) {
			strval=gtk_entry_get_text(GTK_ENTRY(sudoku.square[row][col].entry));
			if(*strval == '\0')
				continue;

			if(L[A[row+1][col+1]] == 'G') {
				if(*strval == '0')
					continue;
			} else if(*strval == L[A[row+1][col+1]])
				continue;

			// mark it red
			snprintf(value_f, 50, "<span foreground=\"#bb0000\">%s</span>",
					strval);
			gtk_label_set_markup(
					GTK_LABEL(sudoku.square[row][col].label), value_f);
			at_least_one_incorrect = true;
	} }
	return at_least_one_incorrect;
}

void verify_game(GtkToolButton *toolbutton, 
				 gpointer       data)
{
	do_verify_game();
}

void do_verify_game(void)
{
	if(designing_sudoku) {
		popup_msg("Sorry", 
				"Nothing can be verified until\n"
				"puzzle is finished.");
		return;
	}
	if(!game_started) return;
	solve(FALSE);
}

void display_solution(void)
{
	register int row;
	register int col;
	char value[2];
	char label_f[50];

	for(row = 0; row < GRID_SIZE; ++row)
	for(col = 0; col < GRID_SIZE; ++col) {
		if(sudoku.square[row][col].editable) {
			value[0] = (L[A[row+1][col+1]] == 'G')? '0': L[A[row+1][col+1]];
			value[1] = '\0';
			gtk_entry_set_text(GTK_ENTRY(sudoku.square[row][col].entry), value);
			snprintf(label_f, 50,
					"<span foreground=\"#009999\">%s</span>", 
					value);
			gtk_label_set_markup(
					GTK_LABEL(sudoku.square[row][col].label), label_f);
	} }
}

void solve(gboolean show_solution)
{
	char value;
	gboolean all_input_read = FALSE;

	N = BLOCK_SIZE;
	N2 = GRID_SIZE;
	N4 = N2*N2;
	m = 4*N4;
	n = N2*N4;

	vmax=4000000;
	
m6:	clues=0;
	i=0;
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y) {
m1:		if(all_input_read) {
			if(solutions == 0)
				popup_msg("X-(",
						"No solution was found here!\n      Major bummer.");
			return;
		}
		if(x == N2 && y == N2)
			all_input_read = TRUE;
		j=0;
		if(sudoku.square[x-1][y-1].editable)
			goto m7;
		value = *gtk_label_get_text(GTK_LABEL(sudoku.square[x-1][y-1].label));
		c = (value=='0')? 'G': value;
		while(L[j]!=c && j<=N2)
			++j;
		if(j>N2)
			goto m1;
m7:		A0[x][y]=j;
		if(j)
			++clues;
		++i;
	}
	if(clues==N4) {
		--clues;
		A0[1][1]=0;
	}

	tnodes=0;

	r=0;
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y)
	for(s = 1; s <= N2; ++s) {
		r++;
		Cols[r]=4;
		Col[r][1]=x*N2-N2+y;
		Col[r][4]=(N*((x-1)/N)+(y-1)/N)*N2+s+N4;
		Col[r][3]=x*N2-N2+s+N4*2;
		Col[r][2]=y*N2-N2+s+N4*3;
	}
	for(c = 1; c <= m; ++c)
		Rows[c]=0;
	for(r = 1; r <= n; ++r)
	for(c = 1; c <= Cols[r]; ++c) {
		x=Col[r][c];
		Rows[x]++;
		Row[x][Rows[x]]=r;
	}
	
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y)
		A[x][y]=A0[x][y];
	for(i = 0; i <= n; ++i)
		Ur[i]=0;
	for(i = 0; i <= m; ++i)
		Uc[i]=0;
	solutions=0;
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y)
		if(A[x][y]) {
			r=x*N4-N4+y*N2-N2+A[x][y];
			for(j = 1;j <= Cols[r]; ++j) {
				c1=Col[r][j];
				if(Uc[c1]>0)
					goto next_try;
				Uc[c1]++;
				for(k = 1; k <= Rows[c1]; ++k) {
					r1=Row[c1][k];
					Ur[r1]++;
		} } }
	for(c = 1; c <= m; ++c) {
		V[c]=0;
		for(r = 1; r <= Rows[c]; ++r)
			if(Ur[Row[c][r]]==0)
				V[c]++;
	}

//---------walk through the searchtree now------------------
	i=clues;
	m0=0;
	m1=0;
	solutions=0;
m2:	++i;
	I[i]=0;
	min=n+1;
	if(i>N4 || m0)
		goto m4;
	if(m1) {
		C[i]=m1;
		goto m3;
	}
	for(c = 1; c <= m; ++c)
		if(!Uc[c]) {
			if(V[c]<=min)
				c1=c;
			if(V[c]<min) {
				min=V[c];
				C[i]=c;
				if(min<2)
					goto m3;
		} }
	if(min>2)
		goto m3;
		
m3:	c=C[i];
	I[i]++;
	if(I[i]>Rows[c])
		goto m4;
	r=Row[c][I[i]];
	if(Ur[r])
		goto m3;
	m0=0;
	m1=0;

	j=N2;
	k=N4;
	x=(r-1)/k+1;
	y=((r-1)%k)/j+1;
	s=(r-1)%j+1;
	A[x][y]=s;
	if(i==k) {
		if(show_solution)
			display_solution();
		else {
			if(!mark_incorrect_squares())
				popup_msg("Status",
						"Woohoo! All numbers are correct so far!");
			else
				popup_msg("Not So Fast",
						"Looks like you made a boo-boo, Bub =P");
	} }
	
	for(j = 1; j <= Cols[r]; ++j) {
		c1=Col[r][j];
		Uc[c1]++;
	}
	for(j = 1; j <= Cols[r]; ++j) {
		c1=Col[r][j];
		for(k = 1; k <= Rows[c1]; ++k) {
			r1=Row[c1][k];
			Ur[r1]++;
			if(Ur[r1]==1)
				for(l = 1; l <= Cols[r1]; ++l) {
					c2=Col[r1][l];
					V[c2]--;
					if(Uc[c2]+V[c2]<1)
						m0=c2;
					if(Uc[c2]==0 && V[c2]<2)
						m1=c2;
	} } }
	++tnodes;
	if(i==N4)
		++solutions;
	if(solutions>=2) {
		popup_msg("!!", "There is more than one solution to this puzzle.");
		goto next_try;
	}
	if(tnodes>vmax) {
		printf("-");
		goto next_try;
	}
	goto m2;
m4:	--i;
	c=C[i];
	r=Row[c][I[i]];
	if(i==clues)
		goto next_try;
	for(j = 1; j <= Cols[r]; ++j) {
		c1=Col[r][j];
		Uc[c1]--;
		for(k = 1; k <= Rows[c1]; ++k) {
			r1=Row[c1][k];
			Ur[r1]--;
			if(Ur[r1]==0)
				for(l = 1; l <= Cols[r1]; ++l) {
					c2=Col[r1][l];
					V[c2]++;
	} } }
	j=N2;
	k=N4;
	x=(r-1)/k+1;
	y=((r-1)%k)/j+1;
	s=(r-1)%j+1;
	A[x][y]=0;
	if(i>clues)
		goto m3;

next_try:;
	goto m6;
}

void solve_game(GtkToolButton *toolbutton, 
				gpointer       data)
{
	do_solve_game();
}

void do_solve_game(void)
{
	if(designing_sudoku) {
		popup_msg("No Can Do", 
				"In order to solve, you need to finish\n"
				"creating your sudoku puzzle.");
		return;
	}

	game_started = false;

	// disallow user from editing any square after calling solve
	if(sudoku.last_square_clicked != NULL 
	   && sudoku.last_square_clicked->editable) {
		gtk_widget_hide(sudoku.last_square_clicked->entry);
		gtk_widget_show(sudoku.last_square_clicked->label);
	}

	solve(TRUE);
}
