// Copyright (C) 2008 Simon Mendoza
// This file is part of gtk-sudoku.
//
// gtk-sudoku is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// gtk-sudoku is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with gtk-sudoku.  If not, see <http://www.gnu.org/licenses/>.

#ifndef GENERATOR_H
#define GENERATOR_H

#include "sudoku.h"
#include <time.h>

int      gen_solve            (int smax);
int      reduce               (int c);
int      unreduce             (int c);
gboolean init_all             (void);
void     free_all             (void);

void     make_grid            (void);
void     display_new_game     (void);
void     clear_sudoku_grid    (void);

void     generate_random_game (void);
void     generate_game        (GtkWidget *toolbutton, 
	    			           GtkWidget *done_btn);

#endif
