#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
newstatesman.com
'''

class NewStatesman(BasicNewsRecipe):
    title                 = 'New Statesman'
    __author__            = 'Darko Miletic'
    description           = "Britain's award-winning current affairs magazine"
    publisher             = 'New Statesman'
    category              = 'news, UK, World'
    oldest_article        = 7
    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = False
    encoding              = 'cp1252'
    remove_javascript     = True
    cover_url             = 'http://media.starbulletin.com/designimages/spacer.gif'

    html2lrf_options = [
                          '--comment'       , description
                        , '--base-font-size', '10'
                        , '--category'      , category
                        , '--publisher'     , publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"'
    
    keep_only_tags = [dict(name='div', attrs={'class':'content-main'})]

    remove_tags = [
                    dict(name=['object','link','form','ul'])
                   ,dict(name='ul', attrs={'class':'post-article'})
                   ,dict(name='div' , attrs={'class':['tag-nav-container','article-base']})
                   ,dict(name='div' , attrs={'id':['reader-comments']})                    
                  ]
                        
    feeds = [
              (u'Articles', u'http://www.newstatesman.com/feeds/contents.rss' )
            ]

    def preprocess_html(self, soup):
        for item in soup.findAll(style=True):
            del item['style']
        mtag = '\n<meta http-equiv="Content-Language" content="en"/>\n'
        soup.head.insert(0,mtag)
        return soup
        