/*
 * ScribblePage.java
 *
 * Created on 13 januari 2007, 23:24
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iliadpdfscribblemerger;

import com.lowagie.text.Rectangle;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import com.lowagie.text.pdf.PdfContentByte;
import java.util.HashMap;

/**
 *
 * @author Bert
 */
public class ScribblePage {
    Color colBackground;
    int nPageId;
    int nOrientation;
    int nHeight, nWidth;
    ScribbleStroke[] arrStrokes;
    
    /** Creates a new instance of ScribblePage */
    public ScribblePage(Element elPage) {
        String strBgColor = elPage.getAttribute("backgroundcolor");
        colBackground = Color.decode(strBgColor);
        String strId = elPage.getAttribute("id");
        nPageId = Integer.parseInt(strId);
        
        NodeList nlstOrientation = elPage.getElementsByTagName("orientation");
        Node nodeOrientation = nlstOrientation.item(0).getChildNodes().item(0);
        nOrientation = Integer.parseInt(nodeOrientation.getNodeValue());
        
        NodeList nlstHeight = elPage.getElementsByTagName("height");
        Node nodeHeight = nlstHeight.item(0).getChildNodes().item(0);
        nHeight = Integer.parseInt(nodeHeight.getNodeValue());
        
        NodeList nlstWidth = elPage.getElementsByTagName("width");
        Node nodeWidth = nlstWidth.item(0).getChildNodes().item(0);
        nWidth = Integer.parseInt(nodeWidth.getNodeValue());
        
        NodeList nlstStrokes = elPage.getElementsByTagName("stroke");
        int nStrokeCount = nlstStrokes.getLength();
        arrStrokes = new ScribbleStroke[nStrokeCount];
        for (int nStroke = 0; nStroke < nStrokeCount; nStroke++) {
            Node nodeStroke = nlstStrokes.item(nStroke);
            if (nodeStroke != null && nodeStroke.getNodeType() == Node.ELEMENT_NODE) {
                Element elStroke = (Element)nodeStroke;
                arrStrokes[nStroke] = new ScribbleStroke(elStroke);
            }
        }
    }
    
    public void AddScribbles(PdfContentByte cbo, PdfContentByte cbu, float fPageTop, float fPageLeft, HashMap mapColors) {
        for (int nStroke=0; nStroke<arrStrokes.length; nStroke++) {
            arrStrokes[nStroke].DrawStroke(cbo, cbu, nOrientation, fPageTop, fPageLeft, mapColors);
        }
    }
}
