/*
 * ColorMap.java
 *
 * Created on 6 april 2007, 19:07
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iliadpdfscribblemerger;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author Bert
 */
public class ColorMap extends HashMap {
    
    /** Creates a new instance of ColorMap */
    public ColorMap() {
    }
    
    public ColorMap(ColorMap mapColors) {
        this.putAll(mapColors);
    }
    
    ///////////////////////////////////////////////////////////////////////
    static public String ColorToString(Color c) {
        //get colors
        String strRed = Integer.toHexString(c.getRed());
        String strGreen = Integer.toHexString(c.getGreen());
        String strBlue = Integer.toHexString(c.getBlue());
        //add leading '0' if needed
        if (strRed.length()<2)
            strRed = "0" + strRed;
        if (strGreen.length()<2)
            strGreen = "0" + strGreen;
        if (strBlue.length()<2)
            strBlue = "0" + strBlue;
        
        String strColor = "#" + strRed + strGreen + strBlue;
        return strColor.toUpperCase();
    }
    
    ///////////////////////////////////////////////////////////////////////
    // ColorMap management
    ///////////////////////////////////////////////////////////////////////
    protected static HashMap mapColorMaps = new HashMap();
    
    public static ColorMap getColorMap(String strName) {
        if (mapColorMaps.containsKey(strName))
            return (ColorMap)mapColorMaps.get(strName);
        else
            return null;
    }
    
    public static void setColorMap(String strName, ColorMap mapColors) {
        if (mapColors == null && mapColorMaps.containsKey(strName))
            mapColorMaps.remove(strName);
        else
            mapColorMaps.put(strName, mapColors);
    }
    
    ///////////////////////////////////////////////////////////////////////
    // Save / Restore
    ///////////////////////////////////////////////////////////////////////
    public static boolean saveToXml(String strXmlFile, String strDefault) {
        try {
            //create DOM
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document docPresets = db.newDocument();
            
            //create root
            Element eRoot = docPresets.createElement("ColorMaps");
            eRoot.setAttribute("default", strDefault);
            docPresets.appendChild(eRoot);
            
            //create node per ColorMap
            Iterator itColorMaps = mapColorMaps.entrySet().iterator();
            while (itColorMaps.hasNext()) {
                //get entry
                Map.Entry entryMap = (Map.Entry)itColorMaps.next();
                String strName = (String)entryMap.getKey();
                ColorMap mapColors = (ColorMap)entryMap.getValue();
                
                //create XML element
                Element eColorMap = docPresets.createElement("ColorMap");
                eColorMap.setAttribute("name", strName);
                eRoot.appendChild(eColorMap);
                
                //create value nodes
                Iterator itColors = mapColors.entrySet().iterator();
                while (itColors.hasNext()) {
                    Map.Entry entryColor = (Map.Entry)itColors.next();
                    String strFrom = (String)entryColor.getKey();
                    Color cTo = (Color)entryColor.getValue();
                    
                    Element eValue = docPresets.createElement("Value");
                    eColorMap.appendChild(eValue);
                    Element eFrom = docPresets.createElement("From");
                    eValue.appendChild(eFrom);
                    eFrom.setTextContent(strFrom);
                    Element eTo = docPresets.createElement("To");
                    eValue.appendChild(eTo);
                    eTo.setTextContent(ColorToString(cTo));
                }
            }
            
            // Prepare the DOM document for writing
            docPresets.normalizeDocument();
            Source source = new DOMSource(docPresets);
            
            // Prepare the output file
            File file = new File(strXmlFile);
            FileWriter writer = new FileWriter(file);
            Result result = new StreamResult(writer);
            
            // Write the DOM document to the file
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(4));
            
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
            transformer.setOutputProperty(OutputKeys.METHOD, "xml");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.transform(source, result);
            
            return true;
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        
        return false;
    }
    
    public static String loadFromXml(String strXmlFile, JComboBox cmbPresets) {
        try {
            File file = new File(strXmlFile);
            if ( !file.exists() )
                return null;
            
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document docPresets = db.parse(file);
            docPresets.getDocumentElement().normalize();
            
            //find default element
            Element eRoot = (Element)docPresets.getElementsByTagName("ColorMaps").item(0);
            String strDefault = eRoot.getAttribute("default");
            if (strDefault == null)
                strDefault = ""; //no default selected
            
            //find color maps
            NodeList nlColorMaps = eRoot.getElementsByTagName("ColorMap");
            for (int nColorMap = 0; nColorMap < nlColorMaps.getLength(); nColorMap++) {
                Node nodeColorMap = nlColorMaps.item(nColorMap);
                if (nodeColorMap != null && nodeColorMap.getNodeType() == Node.ELEMENT_NODE) {
                    //get element
                    Element elColorMap = (Element)nodeColorMap;
                    
                    //get name
                    String strName = elColorMap.getAttribute("name");
                    //get colors
                    ColorMap mapColors = new ColorMap();
                    NodeList nlValues = elColorMap.getElementsByTagName("Value");
                    for (int nValue = 0; nValue<nlValues.getLength(); nValue++) {
                        Element elValue = (Element)nlValues.item(nValue);
                        String strFrom = elValue.getElementsByTagName("From").item(0).getTextContent();
                        String strTo = elValue.getElementsByTagName("To").item(0).getTextContent();
                        Color colTo = Color.decode(strTo);
                        mapColors.put(strFrom, colTo);
                    }
                    
                    //add to map
                    mapColorMaps.put(strName, mapColors);
                    
                    //add it to the combo box
                    if (cmbPresets != null)
                        cmbPresets.insertItemAt(strName, nColorMap);
                }
            }
            
            //select the default item
            if (cmbPresets != null && strDefault != null && strDefault != "")
                cmbPresets.setSelectedItem(strDefault);
            
            return strDefault;
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return null;
    }
}
