#!/usr/bin/env lua
-- A first test for IUP / Lua on the Iliad...
-- Hansel, 20090202

require( "iuplua51" )

-- execute a command and return output as string
function get_command_output(cmd)
  local info,p
  p=io.popen(cmd)
  info = p and p:read('*all') or "error in '" .. cmd .. "'"
  p:close()
  return info
end

-- 4 Buttons,  different ways to set callbacks

b_proc = iup.button{title = "Processes", size='50x20'}

b_net = iup.button{
  Title = "Network", size='50x20',
  action=function() 
    label.title = "Network Status"
    text.value = get_command_output('/sbin/ifconfig')
  end
}

stop  = iup.button{title = "Stop", size='50x20' }

label = iup.label{
   bgcolor = "0 255 255",
   fgcolor = "0 0 0",
   alignment="acenter",
   expand= "horizontal",
   fontsize= "24",
   title="IUP-Lua"
}

function b_proc:action() 
  label.title = "Processes..."
  text.value = get_command_output('/bin/ps')
end

stop.action = function ()
  print "Over and out"
  return iup.CLOSE	-- Ends the mainloop
end

text = iup.text {
  expand= "horizontal", 
  multiline='yes', 
  font= "Monospace, 6",
  size='x300'
}

dlg = iup.dialog {
  title="Lua on the Iliad",		-- dialog title
  margin='5x5',
  bgcolor = "255 255 255",
  iup.vbox{ 
    iup.hbox{
       bgcolor = "200 200 200",
       b_net, b_proc,
       iup.button{
         title = "Time", size='50x20',
         action=function()
           label.title =  get_command_output("date '+%r'")
         end
       },
       stop
    }, 
    label,
    text
  },
}


dlg:showxy(iup.CENTER, iup.CENTER)

if (not iup.MainLoopLevel or iup.MainLoopLevel()==0) then
  iup.MainLoop()
end

