#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


int main(int argc, char **argv)
{
	int timeout=30;
	int asktimeout;
	int counter=0;
	int quit=0;
	int cc,i;
	char date[16];
	char tail[100];
	FILE *fp;

	if(argc==2 && sscanf(argv[1],"%d",&asktimeout) && asktimeout>4)timeout=asktimeout;
	printf("Watchdog - will shutdown Iliad after %d minutes of inactivity\nUse the stopwatchdog command to cancel.\n",timeout);
	if(fork()>0)exit(0);
	setpgrp();
	for(i=getdtablesize();i>=0;--i)close(i);
	i=open("/dev/null",O_RDWR);
	dup(i);
	dup(i);
	
        fp = fopen("/mnt/protected/logfile", "rb");
	fseek(fp,0,SEEK_END);
	while(!quit)
	{
		for (cc = fscanf(fp,"%15c%90[^\n]\n",date,tail); cc != EOF; cc = fscanf(fp,"%15c%90[^\n]\n",date,tail))
		{
			if(strstr(tail,"eink"))counter=0;
			if(strstr(tail,"watchdog quit message"))
			{
				counter=0;
				quit=1;
			}
		}
		if(counter++>=timeout)
		{
			syslog(LOG_WARNING,"Watchdog shutting down the ILiad");
			system("/sbin/shutdown -h now");
			counter=0;
		}
		sleep(60);
	}
	fclose(fp);
      	return EXIT_SUCCESS;
}
