#!/bin/sh
. /usr/bin/do_updates.sh
#/usr/bin/erregInit
#/sbin/syslogd -s 500 -b 0 -O /var/log/messages

# Remove the original battery kernel module and install a modified one.
depmod
modprobe -r battery
modprobe battery

# Normal boot procedure
export DISPLAY=:0
export LD_LIBRARY_PATH=/usr/lib/mozilla-minimo
export MOZILLA_FIVE_HOME=/usr/lib/mozilla-minimo
export HOME=/home/root
export MBPIXBUF_FORCE_32BPP_INTERNAL=1
export TSLIB_TSDEVICE=/dev/ttyS0
export TSLIB_CONFFILE=/etc/ts.conf
export TSLIB_PLUGINDIR=/usr/lib/ts
/usr/bin/displayMgr -p &
/usr/bin/erbusyd &
/usr/bin/Xfbdev -screen 768x1024x8 -3button -dpi 160 -br -nolisten tcp &
/usr/bin/matchbox-window-manager -use_titlebar no -use_cursor no &
/usr/bin/pageBar&

# start toolbar and wait till it runs
/usr/bin/matchbox-panel --size 39 --no-menu --bgcolor White --no-session --default-apps mb-applet-icon-container &
app=mb-applet-icon-container
echo "Waiting for $app ..."
rip=10
while [ $rip -gt 0 ]
do
    sleep 1
    n=`ps | awk "BEGIN              { n = 0   }
                 \\$5 == \\"$app\\" { n++     }
                 END                { print n }"`
    if [ $n -eq 0 ]
    then
        rip=$((rip-1))
    else
        rip=0
    fi
    echo -n .
done
echo "... wait done"

(/usr/bin/contentLister --sync ; reboot) &
/usr/bin/powerMgr&
modprobe phci
modprobe usb-storage
/etc/init.d/hotplug start
modprobe mscd

