/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import iliadpdfscribblemerger.ColorMap;
import iliadpdfscribblemerger.ScribbleMerger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class ScribbleMergeForm
extends JFrame
implements DropTargetListener {
    DropTarget dtSource;
    DropTarget dtDest;
    String strColorMapPresets = "ColorMapPresets.xml";
    private ButtonGroup btgMergeType;
    private JButton btnDestination;
    private JButton btnExit;
    private JButton btnMerge;
    private JButton btnSource;
    private JCheckBox chkKeepManifest;
    private JCheckBox chkScribblesOnly;
    private JComboBox cmbPreset;
    private JLabel lbl00;
    private JLabel lbl00_new;
    private JLabel lbl55;
    private JLabel lbl55_new;
    private JLabel lblAA;
    private JLabel lblAA_new;
    private JLabel lblAddPreset;
    private JLabel lblBusy;
    private JLabel lblDeletePreset;
    private JLabel lblDestination;
    private JLabel lblFF;
    private JLabel lblFF_new;
    private JLabel lblSavePreset;
    private JLabel lblSource;
    private JPanel pblAA;
    private JPanel pnl00;
    private JPanel pnl00_new;
    private JPanel pnl55;
    private JPanel pnl55_new;
    private JPanel pnlAA_new;
    private JPanel pnlColorMapping;
    private JPanel pnlDestination;
    private JPanel pnlFF;
    private JPanel pnlFF_new;
    private JPanel pnlMergeType;
    private JPanel pnlSource;
    private JButton pntMap00;
    private JButton pntMap55;
    private JButton pntMapAA;
    private JButton pntMapFF;
    private JRadioButton rbtMTCreateNew;
    private JRadioButton rbtMTExisting;
    private JRadioButton rbtMTReplaceAll;
    private JTextField txtDestination;
    private JTextField txtSource;

    public ScribbleMergeForm(String strColorMapPresets) {
        this.strColorMapPresets = strColorMapPresets;
        this.initComponents();
        this.lblBusy.setVisible(false);
        if (ColorMap.loadFromXml(strColorMapPresets, this.cmbPreset) != null) {
            this.cmbPresetActionPerformed(null);
        } else {
            this.lblDeletePresetMouseClicked(null);
        }
        this.dtSource = new DropTarget(this.txtSource, this);
        this.dtDest = new DropTarget(this.txtDestination, this);
    }

    private void initComponents() {
        this.btgMergeType = new ButtonGroup();
        this.pnlSource = new JPanel();
        this.lblSource = new JLabel();
        this.txtSource = new JTextField();
        this.btnSource = new JButton();
        this.pnlMergeType = new JPanel();
        this.rbtMTReplaceAll = new JRadioButton();
        this.chkScribblesOnly = new JCheckBox();
        this.chkKeepManifest = new JCheckBox();
        this.rbtMTCreateNew = new JRadioButton();
        this.rbtMTExisting = new JRadioButton();
        this.pnlColorMapping = new JPanel();
        this.pnlFF = new JPanel();
        this.lblFF = new JLabel();
        this.pntMapFF = new JButton();
        this.pnlFF_new = new JPanel();
        this.lblFF_new = new JLabel();
        this.pblAA = new JPanel();
        this.lblAA = new JLabel();
        this.pntMapAA = new JButton();
        this.lblAA_new = new JLabel();
        this.pnlAA_new = new JPanel();
        this.pnl55 = new JPanel();
        this.lbl55 = new JLabel();
        this.pntMap55 = new JButton();
        this.lbl55_new = new JLabel();
        this.pnl55_new = new JPanel();
        this.pnl00 = new JPanel();
        this.lbl00 = new JLabel();
        this.pntMap00 = new JButton();
        this.pnl00_new = new JPanel();
        this.lbl00_new = new JLabel();
        this.lblBusy = new JLabel();
        this.cmbPreset = new JComboBox();
        this.cmbPreset.setModel(new DefaultComboBoxModel(){

            public void insertElementAt(Object element, int index) {
                Comparable c;
                int size = this.getSize();
                for (index = 0; index < size && (c = (Comparable)this.getElementAt(index)).compareTo(element) <= 0; ++index) {
                }
                super.insertElementAt(element, index);
            }
        });
        this.lblDeletePreset = new JLabel();
        this.lblAddPreset = new JLabel();
        this.lblSavePreset = new JLabel();
        this.pnlDestination = new JPanel();
        this.lblDestination = new JLabel();
        this.txtDestination = new JTextField();
        this.btnDestination = new JButton();
        this.btnExit = new JButton();
        this.btnMerge = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("iLiadPdfScribbleMerger");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ScribbleMergeForm.this.formWindowClosing(evt);
            }
        });
        this.pnlSource.setBorder(BorderFactory.createTitledBorder("Source"));
        this.lblSource.setText("iRex pdf-directory:");
        this.txtSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.txtSourceActionPerformed(evt);
            }
        });
        this.btnSource.setText("Browse...");
        this.btnSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.btnSourceActionPerformed(evt);
            }
        });
        GroupLayout pnlSourceLayout = new GroupLayout(this.pnlSource);
        this.pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().addContainerGap().add(this.lblSource).addPreferredGap(0).add(this.txtSource, -1, 290, Short.MAX_VALUE).addPreferredGap(0).add(this.btnSource).addContainerGap()));
        pnlSourceLayout.setVerticalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createParallelGroup(3).add(this.lblSource).add(this.btnSource).add(this.txtSource, -2, -1, -2)));
        this.pnlMergeType.setBorder(BorderFactory.createTitledBorder("Merge type"));
        this.btgMergeType.add(this.rbtMTReplaceAll);
        this.rbtMTReplaceAll.setText("Replace all (replace existing pdf-directory by merged pdf)");
        this.rbtMTReplaceAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtMTReplaceAll.setMargin(new Insets(0, 0, 0, 0));
        this.rbtMTReplaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.rbtMTReplaceAllActionPerformed(evt);
            }
        });
        this.chkScribblesOnly.setText("Scribbled pages only (page number will be added)");
        this.chkScribblesOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkScribblesOnly.setMargin(new Insets(0, 0, 0, 0));
        this.chkScribblesOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.chkScribblesOnlyActionPerformed(evt);
            }
        });
        this.chkKeepManifest.setText("Keep manifest");
        this.chkKeepManifest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkKeepManifest.setMargin(new Insets(0, 0, 0, 0));
        this.chkKeepManifest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.chkKeepManifestActionPerformed(evt);
            }
        });
        this.btgMergeType.add(this.rbtMTCreateNew);
        this.rbtMTCreateNew.setSelected(true);
        this.rbtMTCreateNew.setText("Create new (and keep original files intact)");
        this.rbtMTCreateNew.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtMTCreateNew.setMargin(new Insets(0, 0, 0, 0));
        this.rbtMTCreateNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.rbtMTCreateNewActionPerformed(evt);
            }
        });
        this.btgMergeType.add(this.rbtMTExisting);
        this.rbtMTExisting.setText("Merge in existing file, keep manifest");
        this.rbtMTExisting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtMTExisting.setMargin(new Insets(0, 0, 0, 0));
        this.rbtMTExisting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.rbtMTExistingActionPerformed(evt);
            }
        });
        GroupLayout pnlMergeTypeLayout = new GroupLayout(this.pnlMergeType);
        this.pnlMergeType.setLayout(pnlMergeTypeLayout);
        pnlMergeTypeLayout.setHorizontalGroup(pnlMergeTypeLayout.createParallelGroup(1).add(pnlMergeTypeLayout.createSequentialGroup().addContainerGap().add(pnlMergeTypeLayout.createParallelGroup(1).add(this.rbtMTCreateNew).add(this.rbtMTExisting).add(this.rbtMTReplaceAll).add(pnlMergeTypeLayout.createSequentialGroup().add(17, 17, 17).add(pnlMergeTypeLayout.createParallelGroup(1).add(this.chkKeepManifest).add(this.chkScribblesOnly)))).addContainerGap(187, Short.MAX_VALUE)));
        pnlMergeTypeLayout.setVerticalGroup(pnlMergeTypeLayout.createParallelGroup(1).add(pnlMergeTypeLayout.createSequentialGroup().add(this.rbtMTCreateNew).add(3, 3, 3).add(this.chkScribblesOnly).addPreferredGap(0).add(this.chkKeepManifest).addPreferredGap(0).add(this.rbtMTExisting).addPreferredGap(0).add(this.rbtMTReplaceAll).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlColorMapping.setBorder(BorderFactory.createTitledBorder("Color mapping"));
        this.pnlFF.setBackground(new Color(255, 255, 255));
        this.pnlFF.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlFFLayout = new GroupLayout(this.pnlFF);
        this.pnlFF.setLayout(pnlFFLayout);
        pnlFFLayout.setHorizontalGroup(pnlFFLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnlFFLayout.setVerticalGroup(pnlFFLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lblFF.setText("#FFFFFF");
        this.pntMapFF.setText("->");
        this.pntMapFF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.pntMapFFActionPerformed(evt);
            }
        });
        this.pnlFF_new.setBackground(new Color(255, 255, 255));
        this.pnlFF_new.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlFF_newLayout = new GroupLayout(this.pnlFF_new);
        this.pnlFF_new.setLayout(pnlFF_newLayout);
        pnlFF_newLayout.setHorizontalGroup(pnlFF_newLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnlFF_newLayout.setVerticalGroup(pnlFF_newLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lblFF_new.setText("#FFFFFF");
        this.pblAA.setBackground(new Color(170, 170, 170));
        this.pblAA.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pblAALayout = new GroupLayout(this.pblAA);
        this.pblAA.setLayout(pblAALayout);
        pblAALayout.setHorizontalGroup(pblAALayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pblAALayout.setVerticalGroup(pblAALayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lblAA.setText("#AAAAAA");
        this.pntMapAA.setText("->");
        this.pntMapAA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.pntMapAAActionPerformed(evt);
            }
        });
        this.lblAA_new.setText("#AAAAAA");
        this.pnlAA_new.setBackground(new Color(170, 170, 170));
        this.pnlAA_new.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlAA_newLayout = new GroupLayout(this.pnlAA_new);
        this.pnlAA_new.setLayout(pnlAA_newLayout);
        pnlAA_newLayout.setHorizontalGroup(pnlAA_newLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnlAA_newLayout.setVerticalGroup(pnlAA_newLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.pnl55.setBackground(new Color(85, 85, 85));
        this.pnl55.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnl55Layout = new GroupLayout(this.pnl55);
        this.pnl55.setLayout(pnl55Layout);
        pnl55Layout.setHorizontalGroup(pnl55Layout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnl55Layout.setVerticalGroup(pnl55Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lbl55.setText("#555555");
        this.pntMap55.setText("->");
        this.pntMap55.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.pntMap55ActionPerformed(evt);
            }
        });
        this.lbl55_new.setText("#555555");
        this.pnl55_new.setBackground(new Color(85, 85, 85));
        this.pnl55_new.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnl55_newLayout = new GroupLayout(this.pnl55_new);
        this.pnl55_new.setLayout(pnl55_newLayout);
        pnl55_newLayout.setHorizontalGroup(pnl55_newLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnl55_newLayout.setVerticalGroup(pnl55_newLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.pnl00.setBackground(new Color(0, 0, 0));
        this.pnl00.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnl00Layout = new GroupLayout(this.pnl00);
        this.pnl00.setLayout(pnl00Layout);
        pnl00Layout.setHorizontalGroup(pnl00Layout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnl00Layout.setVerticalGroup(pnl00Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lbl00.setText("#000000");
        this.pntMap00.setText("->");
        this.pntMap00.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.pntMap00ActionPerformed(evt);
            }
        });
        this.pnl00_new.setBackground(new Color(0, 0, 0));
        this.pnl00_new.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnl00_newLayout = new GroupLayout(this.pnl00_new);
        this.pnl00_new.setLayout(pnl00_newLayout);
        pnl00_newLayout.setHorizontalGroup(pnl00_newLayout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        pnl00_newLayout.setVerticalGroup(pnl00_newLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.lbl00_new.setText("#000000");
        this.lblBusy.setIcon(new ImageIcon(this.getClass().getResource("/iliadpdfscribblemerger/res/disk.png")));
        this.lblBusy.setToolTipText("busy");
        this.cmbPreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.cmbPresetActionPerformed(evt);
            }
        });
        this.lblDeletePreset.setIcon(new ImageIcon(this.getClass().getResource("/iliadpdfscribblemerger/res/delete.png")));
        this.lblDeletePreset.setToolTipText("delete");
        this.lblDeletePreset.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScribbleMergeForm.this.lblDeletePresetMouseClicked(evt);
            }
        });
        this.lblAddPreset.setIcon(new ImageIcon(this.getClass().getResource("/iliadpdfscribblemerger/res/add.png")));
        this.lblAddPreset.setToolTipText("add new");
        this.lblAddPreset.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScribbleMergeForm.this.lblAddPresetMouseClicked(evt);
            }
        });
        this.lblSavePreset.setIcon(new ImageIcon(this.getClass().getResource("/iliadpdfscribblemerger/res/accept.png")));
        this.lblSavePreset.setToolTipText("save");
        this.lblSavePreset.setEnabled(false);
        this.lblSavePreset.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScribbleMergeForm.this.lblSavePresetMouseClicked(evt);
            }
        });
        GroupLayout pnlColorMappingLayout = new GroupLayout(this.pnlColorMapping);
        this.pnlColorMapping.setLayout(pnlColorMappingLayout);
        pnlColorMappingLayout.setHorizontalGroup(pnlColorMappingLayout.createParallelGroup(1).add(pnlColorMappingLayout.createSequentialGroup().addContainerGap().add(pnlColorMappingLayout.createParallelGroup(1).add(pnlColorMappingLayout.createSequentialGroup().add(this.pblAA, -2, -1, -2).addPreferredGap(0).add(this.lblAA)).add(pnlColorMappingLayout.createSequentialGroup().add(this.pnlFF, -2, -1, -2).addPreferredGap(0).add(this.lblFF, -2, 65, -2)).add(pnlColorMappingLayout.createSequentialGroup().add(this.pnl55, -2, -1, -2).addPreferredGap(0).add(this.lbl55)).add(pnlColorMappingLayout.createSequentialGroup().add(this.pnl00, -2, -1, -2).addPreferredGap(0).add(this.lbl00, -2, 44, -2))).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(1).add(this.pntMapAA).add(this.pntMapFF).add(this.pntMap55).add(this.pntMap00)).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(2).add(pnlColorMappingLayout.createSequentialGroup().add(pnlColorMappingLayout.createParallelGroup(2).add(this.pnlAA_new, -2, -1, -2).add(this.pnlFF_new, -2, -1, -2)).addPreferredGap(0)).add(pnlColorMappingLayout.createSequentialGroup().add(pnlColorMappingLayout.createParallelGroup(2).add(this.pnl00_new, -2, -1, -2).add(this.pnl55_new, -2, -1, -2)).addPreferredGap(0))).add(pnlColorMappingLayout.createParallelGroup(1).add(pnlColorMappingLayout.createParallelGroup(2).add(this.lblFF_new, -2, 93, -2).add(this.lbl55_new).add(this.lbl00_new, -2, 44, -2)).add(this.lblAA_new)).add(56, 56, 56).add(pnlColorMappingLayout.createParallelGroup(1, false).add(2, pnlColorMappingLayout.createSequentialGroup().add(this.lblBusy).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.lblSavePreset).addPreferredGap(0).add(this.lblAddPreset).addPreferredGap(0).add(this.lblDeletePreset)).add(this.cmbPreset, -2, 148, -2)).add(161, 161, 161)));
        pnlColorMappingLayout.linkSize(new Component[]{this.lbl00_new, this.lbl55_new, this.lblAA_new, this.lblFF_new}, 1);
        pnlColorMappingLayout.linkSize(new Component[]{this.lbl00, this.lbl55, this.lblAA}, 1);
        pnlColorMappingLayout.setVerticalGroup(pnlColorMappingLayout.createParallelGroup(1).add(2, pnlColorMappingLayout.createSequentialGroup().addContainerGap().add(pnlColorMappingLayout.createParallelGroup(1).add(pnlColorMappingLayout.createSequentialGroup().add(pnlColorMappingLayout.createParallelGroup(2).add(this.pnlFF, -2, -1, -2).add(pnlColorMappingLayout.createParallelGroup(3).add(this.lblFF).add(this.pntMapFF))).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(2).add(this.pblAA, -2, -1, -2).add(pnlColorMappingLayout.createParallelGroup(3).add(this.lblAA).add(this.pntMapAA))).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(2).add(this.pnl55, -2, -1, -2).add(pnlColorMappingLayout.createParallelGroup(3).add(this.lbl55).add(this.pntMap55))).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(1).add(2, this.pnl00, -2, -1, -2).add(2, pnlColorMappingLayout.createParallelGroup(3).add(this.lbl00).add(this.pntMap00)))).add(2, pnlColorMappingLayout.createSequentialGroup().add(pnlColorMappingLayout.createParallelGroup(2).add(this.lblBusy).add(this.lblSavePreset).add(this.lblAddPreset).add(this.lblDeletePreset).add(pnlColorMappingLayout.createSequentialGroup().add(pnlColorMappingLayout.createParallelGroup(1).add(this.lblFF_new).add(this.pnlFF_new, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(2).add(pnlColorMappingLayout.createSequentialGroup().add(this.lblAA_new).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.lbl55_new)).add(1, pnlColorMappingLayout.createSequentialGroup().add(this.pnlAA_new, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.pnl55_new, -2, -1, -2))))).addPreferredGap(0).add(pnlColorMappingLayout.createParallelGroup(2).add(pnlColorMappingLayout.createParallelGroup(3).add(this.lbl00_new).add(this.cmbPreset, -2, -1, -2)).add(this.pnl00_new, -2, -1, -2)))).addContainerGap()));
        pnlColorMappingLayout.linkSize(new Component[]{this.lblFF, this.lblFF_new, this.pnlFF, this.pnlFF_new, this.pntMapFF}, 2);
        pnlColorMappingLayout.linkSize(new Component[]{this.lblAA, this.lblAA_new, this.pblAA, this.pnlAA_new, this.pntMapAA}, 2);
        pnlColorMappingLayout.linkSize(new Component[]{this.lbl55, this.lbl55_new, this.pnl55, this.pnl55_new, this.pntMap55}, 2);
        pnlColorMappingLayout.linkSize(new Component[]{this.lbl00, this.lbl00_new, this.pnl00, this.pnl00_new, this.pntMap00}, 2);
        this.pnlDestination.setBorder(BorderFactory.createTitledBorder("Destination"));
        this.lblDestination.setText("path:");
        this.txtDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.txtDestinationActionPerformed(evt);
            }
        });
        this.btnDestination.setText("Browse...");
        this.btnDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.btnDestinationActionPerformed(evt);
            }
        });
        GroupLayout pnlDestinationLayout = new GroupLayout(this.pnlDestination);
        this.pnlDestination.setLayout(pnlDestinationLayout);
        pnlDestinationLayout.setHorizontalGroup(pnlDestinationLayout.createParallelGroup(1).add(pnlDestinationLayout.createSequentialGroup().addContainerGap().add(this.lblDestination).addPreferredGap(0).add(this.txtDestination, -1, 355, Short.MAX_VALUE).addPreferredGap(0).add(this.btnDestination).addContainerGap()));
        pnlDestinationLayout.setVerticalGroup(pnlDestinationLayout.createParallelGroup(1).add(pnlDestinationLayout.createSequentialGroup().add(pnlDestinationLayout.createParallelGroup(3).add(this.lblDestination).add(this.btnDestination).add(this.txtDestination, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.btnExitActionPerformed(evt);
            }
        });
        this.btnMerge.setText("Merge");
        this.btnMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScribbleMergeForm.this.btnMergeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.pnlColorMapping, -1, 506, Short.MAX_VALUE).add(2, this.pnlMergeType, -1, -1, Short.MAX_VALUE).add(this.pnlSource, -1, -1, Short.MAX_VALUE).add(this.pnlDestination, -1, -1, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(this.btnMerge).addPreferredGap(0).add(this.btnExit))).addContainerGap()));
        layout.linkSize(new Component[]{this.btnExit, this.btnMerge}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.pnlSource, -2, -1, -2).addPreferredGap(0).add(this.pnlMergeType, -2, -1, -2).addPreferredGap(0).add(this.pnlColorMapping, -2, -1, -2).addPreferredGap(0).add(this.pnlDestination, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.btnMerge).add(this.btnExit)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        String strCurrentItem = (String)this.cmbPreset.getSelectedItem();
        if (strCurrentItem != null && strCurrentItem != "") {
            ColorMap.saveToXml(this.strColorMapPresets, strCurrentItem);
        }
    }

    private void lblDeletePresetMouseClicked(MouseEvent evt) {
        if (!this.lblDeletePreset.isEnabled()) {
            return;
        }
        this.showBusyIcon(500);
        String strSelectedItem = (String)this.cmbPreset.getSelectedItem();
        if (strSelectedItem != null && strSelectedItem != "") {
            ColorMap.setColorMap(strSelectedItem, null);
            ColorMap.saveToXml(this.strColorMapPresets, strSelectedItem);
            this.lblSavePreset.setEnabled(false);
            this.lblDeletePreset.setEnabled(false);
            this.cmbPreset.removeItem(strSelectedItem);
            this.cmbPreset.setSelectedIndex(-1);
        }
        this.pnlFF_new.setBackground(new Color(255, 255, 255));
        this.lblFF_new.setText("#FFFFFF");
        this.pnlAA_new.setBackground(new Color(170, 170, 170));
        this.lblAA_new.setText("#AAAAAA");
        this.pnl55_new.setBackground(new Color(85, 85, 85));
        this.lbl55_new.setText("#555555");
        this.pnl00_new.setBackground(new Color(0, 0, 0));
        this.lbl00_new.setText("#000000");
        this.lblDeletePreset.setEnabled(false);
    }

    private void lblSavePresetMouseClicked(MouseEvent evt) {
        if (!this.lblSavePreset.isEnabled()) {
            return;
        }
        this.showBusyIcon(500);
        String strSelectedItem = (String)this.cmbPreset.getSelectedItem();
        if (strSelectedItem != null && strSelectedItem != "") {
            ColorMap.setColorMap(strSelectedItem, this.getNewColorMap());
            ColorMap.saveToXml(this.strColorMapPresets, strSelectedItem);
            this.lblSavePreset.setEnabled(false);
        }
    }

    private void cmbPresetActionPerformed(ActionEvent evt) {
        String strSelectedItem = (String)this.cmbPreset.getSelectedItem();
        ColorMap cmNew = ColorMap.getColorMap(strSelectedItem);
        if (cmNew == null) {
            return;
        }
        this.lblSavePreset.setEnabled(false);
        this.lblDeletePreset.setEnabled(true);
        Color c = null;
        c = (Color)cmNew.get("#FFFFFF");
        if (c != null) {
            this.pnlFF_new.setBackground(c);
            this.lblFF_new.setText(ColorMap.ColorToString(c));
        }
        if ((c = (Color)cmNew.get("#AAAAAA")) != null) {
            this.pnlAA_new.setBackground(c);
            this.lblAA_new.setText(ColorMap.ColorToString(c));
        }
        if ((c = (Color)cmNew.get("#555555")) != null) {
            this.pnl55_new.setBackground(c);
            this.lbl55_new.setText(ColorMap.ColorToString(c));
        }
        if ((c = (Color)cmNew.get("#000000")) != null) {
            this.pnl00_new.setBackground(c);
            this.lbl00_new.setText(ColorMap.ColorToString(c));
        }
    }

    private void lblAddPresetMouseClicked(MouseEvent evt) {
        this.showBusyIcon(500);
        String strNewName = JOptionPane.showInputDialog(this, "Enter the name for the new color map:", "New color map", -1);
        if (strNewName != null && strNewName != "") {
            ColorMap.setColorMap(strNewName, this.getNewColorMap());
            ColorMap.saveToXml(this.strColorMapPresets, strNewName);
            this.lblSavePreset.setEnabled(false);
            this.cmbPreset.insertItemAt(strNewName, 0);
            this.cmbPreset.setSelectedItem(strNewName);
        }
    }

    private void txtDestinationActionPerformed(ActionEvent evt) {
        this.setDestination(this.txtDestination.getText());
    }

    private void txtSourceActionPerformed(ActionEvent evt) {
        this.setSource(this.txtSource.getText());
    }

    private void chkKeepManifestActionPerformed(ActionEvent evt) {
        this.chkScribblesOnly.setEnabled(!this.chkKeepManifest.isSelected());
        this.chkKeepManifest.setEnabled(!this.chkScribblesOnly.isSelected());
    }

    private void chkScribblesOnlyActionPerformed(ActionEvent evt) {
        this.chkScribblesOnly.setEnabled(!this.chkKeepManifest.isSelected());
        this.chkKeepManifest.setEnabled(!this.chkScribblesOnly.isSelected());
    }

    private void pntMap00ActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "#000000 color mapping", this.pnl00_new.getBackground());
        if (c != null) {
            this.pnl00_new.setBackground(c);
            this.lbl00_new.setText(ColorMap.ColorToString(c));
            this.lblSavePreset.setEnabled(this.cmbPreset.getSelectedIndex() >= 0);
        }
    }

    private void pntMap55ActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "#555555 color mapping", this.pnl55_new.getBackground());
        if (c != null) {
            this.pnl55_new.setBackground(c);
            this.lbl55_new.setText(ColorMap.ColorToString(c));
            this.lblSavePreset.setEnabled(this.cmbPreset.getSelectedIndex() >= 0);
        }
    }

    private void pntMapAAActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "#AAAAAA color mapping", this.pnlAA_new.getBackground());
        if (c != null) {
            this.pnlAA_new.setBackground(c);
            this.lblAA_new.setText(ColorMap.ColorToString(c));
            this.lblSavePreset.setEnabled(this.cmbPreset.getSelectedIndex() >= 0);
        }
    }

    private void pntMapFFActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "#FFFFFF color mapping", this.pnlFF_new.getBackground());
        if (c != null) {
            this.pnlFF_new.setBackground(c);
            this.lblFF_new.setText(ColorMap.ColorToString(c));
            this.lblSavePreset.setEnabled(this.cmbPreset.getSelectedIndex() >= 0);
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, 201));
    }

    private void btnMergeActionPerformed(ActionEvent evt) {
        String strInputPath = this.txtSource.getText();
        String strOutputPath = this.txtDestination.getText();
        char cMergeType = 'n';
        if (this.rbtMTCreateNew.isSelected()) {
            cMergeType = this.chkKeepManifest.isSelected() ? (char)'m' : (this.chkScribblesOnly.isSelected() ? (char)'s' : 'n');
        } else if (this.rbtMTExisting.isSelected()) {
            cMergeType = 'e';
        } else if (this.rbtMTReplaceAll.isSelected()) {
            cMergeType = 'r';
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ScribbleMerger.Merge(strInputPath, strOutputPath, cMergeType, this.getNewColorMap());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void showBusyIcon(int nTime_ms) {
        this.lblBusy.setVisible(true);
        Timer timer = new Timer(nTime_ms, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScribbleMergeForm.this.lblBusy.setVisible(false);
            }
        });
        timer.start();
    }

    protected ColorMap getNewColorMap() {
        ColorMap mapColors = new ColorMap();
        mapColors.put("#000000", this.pnl00_new.getBackground());
        mapColors.put("#555555", this.pnl55_new.getBackground());
        mapColors.put("#AAAAAA", this.pnlAA_new.getBackground());
        mapColors.put("#FFFFFF", this.pnlFF_new.getBackground());
        return mapColors;
    }

    private void btnDestinationActionPerformed(ActionEvent evt) {
        File fileOutput = new File(this.txtDestination.getText());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(fileOutput);
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".pdf");
            }

            public String getDescription() {
                return "pdf directories";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showSaveDialog(this);
        if (nReturnValue == 0) {
            this.setDestination(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void rbtMTReplaceAllActionPerformed(ActionEvent evt) {
        this.chkScribblesOnly.setEnabled(false);
        this.chkKeepManifest.setEnabled(false);
        this.lblDestination.setEnabled(false);
        this.txtDestination.setEnabled(false);
        this.btnDestination.setEnabled(false);
        this.FixDestination();
    }

    private void rbtMTExistingActionPerformed(ActionEvent evt) {
        this.chkScribblesOnly.setEnabled(false);
        this.chkKeepManifest.setEnabled(false);
        this.lblDestination.setEnabled(false);
        this.txtDestination.setEnabled(false);
        this.btnDestination.setEnabled(false);
        this.FixDestination();
    }

    private void rbtMTCreateNewActionPerformed(ActionEvent evt) {
        this.chkScribblesOnly.setEnabled(!this.chkKeepManifest.isSelected());
        this.chkKeepManifest.setEnabled(!this.chkScribblesOnly.isSelected());
        this.lblDestination.setEnabled(true);
        this.txtDestination.setEnabled(true);
        this.btnDestination.setEnabled(true);
        this.FixDestination();
    }

    private void FixDestination() {
        File fileInput;
        if (this.rbtMTCreateNew.isSelected()) {
            File fileInput2 = new File(this.txtSource.getText());
            if (fileInput2 != null && fileInput2.isDirectory()) {
                String strSourceDir = fileInput2.getAbsolutePath();
                String strSourcePDF = fileInput2.getAbsolutePath() + File.separator + fileInput2.getName();
                String strDestination = this.txtDestination.getText();
                if (strDestination.equals(strSourceDir) || strDestination.equals(strSourcePDF)) {
                    this.txtDestination.setText("");
                }
            }
        } else if (this.rbtMTExisting.isSelected()) {
            File fileInput3 = new File(this.txtSource.getText());
            if (fileInput3 != null && fileInput3.isDirectory()) {
                this.setDestination(fileInput3.getAbsolutePath() + File.separator + fileInput3.getName());
            }
        } else if (this.rbtMTReplaceAll.isSelected() && (fileInput = new File(this.txtSource.getText())) != null && fileInput.isDirectory()) {
            this.txtDestination.setText(fileInput.getAbsolutePath());
        }
    }

    private void btnSourceActionPerformed(ActionEvent evt) {
        File fileInput = new File(this.txtSource.getText());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(fileInput);
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "iRex pdf directories";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue == 0) {
            this.setSource(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                File file = (File)((List)tr.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                if (file != null) {
                    if (dtde.getSource() == this.dtSource) {
                        this.setSource(file.getAbsolutePath());
                    } else {
                        this.setDestination(file.getAbsolutePath());
                    }
                }
                dtde.dropComplete(true);
                return;
            }
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(1);
                String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                if (str != null) {
                    if (dtde.getSource() == this.dtSource) {
                        this.setSource(str);
                    } else {
                        this.setDestination(str);
                    }
                }
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    private boolean setSource(String strSource) {
        File fileSource = new File(strSource);
        this.txtSource.setText("");
        if (!fileSource.exists() || !fileSource.isDirectory()) {
            return false;
        }
        if (new File(fileSource.getAbsoluteFile() + File.separator + "manifest.xml").exists() && new File(fileSource.getAbsoluteFile() + File.separator + "scribble.irx").exists()) {
            this.txtSource.setText(fileSource.getAbsolutePath());
            if (this.txtDestination.getText() == null || this.txtDestination.getText().length() == 0) {
                this.setDestination(fileSource.getParent() + File.separator);
            }
            this.FixDestination();
            return true;
        }
        return false;
    }

    private void setDestination(String strDest) {
        File fileDest = new File(strDest);
        String strDestination = fileDest.getAbsolutePath();
        if (strDest.endsWith(File.separator)) {
            strDestination = strDestination + File.separator + "output.pdf";
        }
        if (!strDestination.toLowerCase().endsWith(".pdf")) {
            strDestination = strDestination + ".pdf";
        }
        this.txtDestination.setText(strDestination);
    }
}

