/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColorMap
extends HashMap {
    protected static HashMap mapColorMaps = new HashMap();

    public ColorMap() {
    }

    public ColorMap(ColorMap mapColors) {
        this.putAll(mapColors);
    }

    public static String ColorToString(Color c) {
        String strRed = Integer.toHexString(c.getRed());
        String strGreen = Integer.toHexString(c.getGreen());
        String strBlue = Integer.toHexString(c.getBlue());
        if (strRed.length() < 2) {
            strRed = "0" + strRed;
        }
        if (strGreen.length() < 2) {
            strGreen = "0" + strGreen;
        }
        if (strBlue.length() < 2) {
            strBlue = "0" + strBlue;
        }
        String strColor = "#" + strRed + strGreen + strBlue;
        return strColor.toUpperCase();
    }

    public static ColorMap getColorMap(String strName) {
        if (mapColorMaps.containsKey(strName)) {
            return (ColorMap)mapColorMaps.get(strName);
        }
        return null;
    }

    public static void setColorMap(String strName, ColorMap mapColors) {
        if (mapColors == null && mapColorMaps.containsKey(strName)) {
            mapColorMaps.remove(strName);
        } else {
            mapColorMaps.put(strName, mapColors);
        }
    }

    public static boolean saveToXml(String strXmlFile, String strDefault) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document docPresets = db.newDocument();
            Element eRoot = docPresets.createElement("ColorMaps");
            eRoot.setAttribute("default", strDefault);
            docPresets.appendChild(eRoot);
            Iterator itColorMaps = mapColorMaps.entrySet().iterator();
            while (itColorMaps.hasNext()) {
                Map.Entry entryMap = itColorMaps.next();
                String strName = (String)entryMap.getKey();
                ColorMap mapColors = (ColorMap)entryMap.getValue();
                Element eColorMap = docPresets.createElement("ColorMap");
                eColorMap.setAttribute("name", strName);
                eRoot.appendChild(eColorMap);
                Iterator itColors = mapColors.entrySet().iterator();
                while (itColors.hasNext()) {
                    Map.Entry entryColor = itColors.next();
                    String strFrom = (String)entryColor.getKey();
                    Color cTo = (Color)entryColor.getValue();
                    Element eValue = docPresets.createElement("Value");
                    eColorMap.appendChild(eValue);
                    Element eFrom = docPresets.createElement("From");
                    eValue.appendChild(eFrom);
                    eFrom.setTextContent(strFrom);
                    Element eTo = docPresets.createElement("To");
                    eValue.appendChild(eTo);
                    eTo.setTextContent(ColorMap.ColorToString(cTo));
                }
            }
            docPresets.normalizeDocument();
            DOMSource source = new DOMSource(docPresets);
            File file = new File(strXmlFile);
            FileWriter writer = new FileWriter(file);
            StreamResult result = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            return true;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static String loadFromXml(String strXmlFile, JComboBox cmbPresets) {
        try {
            File file = new File(strXmlFile);
            if (!file.exists()) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document docPresets = db.parse(file);
            docPresets.getDocumentElement().normalize();
            Element eRoot = (Element)docPresets.getElementsByTagName("ColorMaps").item(0);
            String strDefault = eRoot.getAttribute("default");
            if (strDefault == null) {
                strDefault = "";
            }
            NodeList nlColorMaps = eRoot.getElementsByTagName("ColorMap");
            for (int nColorMap = 0; nColorMap < nlColorMaps.getLength(); ++nColorMap) {
                Node nodeColorMap = nlColorMaps.item(nColorMap);
                if (nodeColorMap == null || nodeColorMap.getNodeType() != 1) continue;
                Element elColorMap = (Element)nodeColorMap;
                String strName = elColorMap.getAttribute("name");
                ColorMap mapColors = new ColorMap();
                NodeList nlValues = elColorMap.getElementsByTagName("Value");
                for (int nValue = 0; nValue < nlValues.getLength(); ++nValue) {
                    Element elValue = (Element)nlValues.item(nValue);
                    String strFrom = elValue.getElementsByTagName("From").item(0).getTextContent();
                    String strTo = elValue.getElementsByTagName("To").item(0).getTextContent();
                    Color colTo = Color.decode(strTo);
                    mapColors.put(strFrom, colTo);
                }
                mapColorMaps.put(strName, mapColors);
                if (cmbPresets == null) continue;
                cmbPresets.insertItemAt(strName, nColorMap);
            }
            if (cmbPresets != null && strDefault != null && strDefault != "") {
                cmbPresets.setSelectedItem(strDefault);
            }
            return strDefault;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

