#!/bin/sh
SCRIPTDIR=`/usr/bin/dirname "$0"`
Firmware_iLiad=`cat /etc/er_version_commercial`

cd "$SCRIPTDIR"
Firmware_Script=`cat Firmware_Script`

#####################################################
#if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
if echo $Firmware_iLiad | grep $Firmware_Script - ; then
	FILESIZE=$(ls -l /usr/bin/pageBar | awk '{print $5}')

	if [ ! $FILESIZE = "21572" ]; then
		#kill the current pageBar process
		killall pageBar

		#copy the original file to the uninstall dir, thus making a backup
		if [ ! -f ../uninstall/pageBar0 ]; then
			cp /usr/bin/pageBar ../uninstall/pageBar0
			cp /usr/share/pagebar/pagebar_cpi.png ../uninstall/pagebar_cpi0.png
		fi

		#copy files to device
		cp ./clockpageBar /usr/bin/pageBar
		cp ./pagebar_cpi.png /usr/share/pagebar/pagebar_cpi.png
		
		chmod 755 /usr/bin/pageBar
		
		#remove this (better ask for reboot)
		/usr/bin/pageBar &
	fi
	
	#####################################################
	FILESIZE=$(ls -l /usr/bin/pageBar | awk '{print $5}')

	if [ $FILESIZE = "21572" ]; then
		cp ./manifest_ok.xml ./manifest.xml
	else
		cp ./manifest_nok.xml ./manifest.xml
	fi	
else
	cat ./wrong_fw0.xml | sed -e "s/Firmware_Script_xml/$Firmware_Script/" > ./wrong_fw1.xml
	cat ./wrong_fw1.xml | sed -e "s/Firmware_iLiad_xml/$Firmware_iLiad/" > ./wrong_fw.xml
	
	rm -f ./wrong_fw1.xml
	
	mv ./wrong_fw.xml ./manifest.xml
fi