#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# Log file
LOGDIR=../logfile
LOGFILE=$LOGDIR/uninstall-log.txt
mkdir $LOGDIR
rm $LOGFILE

# Functions for updating the log file
log_success()
{
	cp manifest_ok.xml $LOGDIR/manifest.xml
	cp icon_ok.png $LOGDIR/icon.png
        echo Uninstall successful
}

log_failed()
{
	echo $1
	cat manifest_failed.xml | sed -e "s/ERROR/$1/" > $LOGDIR/manifest.xml
	cp icon_failed.png $LOGDIR/icon.png
}

# Dump everything from now on to the logfile
exec 1>> $LOGFILE 2>> $LOGFILE

# Assume the worst case (uninstall failed) and echo a starting message
log_failed "Starting uninstall"

# Uninstall the package
ipkg remove iViewer
code=$?
if [ $code = 0 ]; then
	# Uninstall successful
	log_success
else
	# ipkg failed for some reason
	log_failed "ipkg failed with code $code"
fi
