#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'

from qt.core import QCheckBox, QLabel, QVBoxLayout, QWidget

from calibre.utils.config import JSONConfig


KEY_SHOW_CONFIRMATION = 'show_confirmation'
KEY_SHOW_BADGE = 'show_badge'

# Stored under calibre config_dir/plugins/
plugin_prefs = JSONConfig('plugins/Input Order Swap')
plugin_prefs.defaults[KEY_SHOW_CONFIRMATION] = True
plugin_prefs.defaults[KEY_SHOW_BADGE] = True


class ConfigWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)

        # calibre's customization dialog can end up very short; enforce a minimum
        # height so the options are visible without awkward scrolling.
        self.setMinimumHeight(170)

        self.l = QVBoxLayout(self)
        self.l.addWidget(QLabel('Options:'))

        self.show_confirmation = QCheckBox('Show confirmation dialog after swapping', self)
        self.show_confirmation.setChecked(bool(plugin_prefs.get(KEY_SHOW_CONFIRMATION, True)))
        self.l.addWidget(self.show_confirmation)

        self.show_badge = QCheckBox('Show IN badge overlay on the toolbar icon', self)
        self.show_badge.setChecked(bool(plugin_prefs.get(KEY_SHOW_BADGE, True)))
        self.l.addWidget(self.show_badge)

        self.l.addStretch(1)

    def save_settings(self):
        plugin_prefs[KEY_SHOW_CONFIRMATION] = bool(self.show_confirmation.isChecked())
        plugin_prefs[KEY_SHOW_BADGE] = bool(self.show_badge.isChecked())
