#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase


class ToggleInputFormat(InterfaceActionBase):
    name = 'Input Order Swap'
    description = 'Toolbar button to swap the top two formats in the preferred input order'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 0, 0)
    minimum_calibre_version = (6, 25, 0)

    actual_plugin = 'calibre_plugins.input_order_swap.ui:ToggleInputFormatAction'

    def is_customizable(self):
        return True

    def config_widget(self):
        from .config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()
        # Update the live toolbar icon immediately if the action is loaded.
        if getattr(self, 'actual_plugin_', None):
            try:
                self.actual_plugin_.rebuild_icon()
            except Exception:
                pass
