#!/usr/bin/env python
import os
from calibre.utils.logging import default_log as debug_print
from calibre.gui2 import I
from PyQt5.Qt import QIcon

def get_icon(icon_name):
    '''
    Retrieve a QIcon for the named image from:
    1. The plugin's images directory
    2. Calibre's image cache using QIcon.ic()
    3. Calibre's resources system
    4. Blank icon if all else fails
    '''
    if not icon_name:
        return QIcon()

    # First try plugin's images directory
    plugin_dir = os.path.dirname(__file__)
    icon_path = os.path.join(plugin_dir, 'images', icon_name)
    if (os.path.exists(icon_path)):
        icon = QIcon(icon_path)
        if not icon.isNull():
            debug_print(f'OPFHelper: Found icon in plugin directory: {icon_path}')
            return icon

    # Next try calibre's icon cache for theme-aware icons
    icon = QIcon.ic(icon_name)
    if not icon.isNull():
        debug_print(f'OPFHelper: Found theme-aware icon {icon_name} in Calibre icon cache') 
        return icon
        
    # Try calibre's resources system
    icon = get_icons(icon_name, print_tracebacks_for_missing_resources=False)
    if icon and not icon.isNull():  # Fixed: changed '&&' to 'and'
        debug_print(f'OPFHelper: Found {icon_name} in Calibre resources')
        return icon
        
    # Return blank icon as fallback
    debug_print(f'OPFHelper: No icon found for {icon_name}, using blank icon')
    return QIcon(I('blank.png'))

def is_dark_theme():
    """Check if Calibre is using dark theme"""
    from calibre.gui2 import is_dark_theme as calibre_is_dark
    try:
        return calibre_is_dark()
    except:
        return False