#!/usr/bin/env python

# Plugin version numbering
MINIMUM_CALIBRE_VERSION = (6, 0, 0)

# Plugin icon files
PLUGIN_ICONS = ['images/icon-for-dark-theme.png', 'images/icon-for-light-theme.png', 'images/xml_error.png']

# Default tab order
DEFAULT_TAB_ORDER = ['OPF Tree', 'Statistics', 'Validation', 'XML']

# OPF documentation and references
REFERENCES = {
    'MobileRead OPF Wiki': 'https://wiki.mobileread.com/wiki/OPF',  # Add this first for prominence
    'EPUB 3.0': 'https://www.w3.org/TR/epub-33/',
    'EPUB 2.0': 'http://idpf.org/epub/20/spec/OPF_2.0.1_draft.htm',
    'Dublin Core Metadata': 'https://www.dublincore.org/specifications/dublin-core/dces/',
    'OPF 2.0 Specification': 'http://idpf.org/epub/20/spec/OPF_2.0.1_draft.htm',
    'OPF 3.0 Specification': 'https://www.w3.org/TR/epub-33/#sec-package-doc'
}

# Element help text for tooltips
OPF_HELP = {
    'package': 'Root element of the OPF file. Contains metadata, manifest, and spine sections.',
    'metadata': 'Contains all book metadata like title, author, etc. Uses Dublin Core elements.',
    'manifest': 'Lists all files (content documents, images, etc.) that are part of the publication.',
    'spine': 'Defines the reading order of content documents.',
    'guide': 'Optional element providing links to key structural components (EPUB 2.0).',
    'title': 'The title of the publication.',
    'creator': 'The primary author or creator of the publication.',
    'contributor': 'Other contributors to the content (e.g., illustrator, editor).',
    'publisher': 'The publisher of the publication.',
    'date': 'Publication date, typically in YYYY[-MM[-DD]] format.',
    'language': 'The language of the content (RFC 3066 language codes).',
    'identifier': 'Unique identifier for the publication (e.g., ISBN, UUID).',
    'subject': 'Subject categories or keywords describing the content.',
    'description': 'A description or summary of the publication.',
    'rights': 'Copyright and licensing information.',
    'item': 'Manifest entry representing a publication resource (content, images, etc).',
    'itemref': 'Spine entry referencing a manifest item, defining reading order.',
    'reference': 'Guide entry pointing to a key structural component.',
    # Attributes
    'id': 'Unique identifier within the OPF file',
    'href': 'Path to the referenced file',
    'media-type': 'MIME type of the referenced file',
    'unique-identifier': 'References the primary identifier in metadata',
    'version': 'EPUB specification version (2.0 or 3.0)',
    'toc': 'References the navigation control file (NCX/Nav)',
    'properties': 'Special features of the referenced item (EPUB 3.0)',
    'fallback': 'Alternative version if primary cannot be rendered',
    'linear': 'Whether item is part of primary reading order (yes/no)'
}

# Theme-specific colors for metadata fields
DARK_MODE_COLORS = {
    'title': "#fbff17",       # Bright yellow
    'creator': "#50E3C2",     # Bright teal
    'publisher': "#FF9D88",   # Bright salmon
    'subject': "#90EE90",     # Light green
    'language': "#FFB366",    # Bright orange
    'identifier': "#FF99CC",  # Bright pink
    'date': "#B19CD9",       # Light purple
    'description': "#88CCFF"  # Bright light blue
}

LIGHT_MODE_COLORS = {
    'title': "#8B4513",      # Saddle Brown (darker)
    'creator': "#1A3333",    # Darker slate gray
    'publisher': "#8B0000",  # Dark Red
    'subject': "#004225",    # Darker forest green
    'language': "#A0522D",   # Sienna
    'identifier': "#2A0066", # Darker indigo
    'date': "#483D8B",      # Dark Slate Blue
    'description': "#00008B" # Dark Blue
}