#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class KoboTouchConfigButton(InterfaceActionBase):
    name = 'KoboTouch Config Button'
    description = 'Quick access to KoboTouch device driver configuration'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 0, 1)
    minimum_calibre_version = (8, 0, 0)
    actual_plugin = 'calibre_plugins.kobotouch_config_button.action:KoboTouchConfigButtonAction'

    def is_customizable(self):
        # Allow the toolbar action to be customized/removed by the user
        return True

    def do_user_config(self, parent=None):
        """
        Handle the Plugins->Configure action. If the actual plugin action
        implements a UI hook (for example `show_kobo_config`) call it; if not,
        show a short info message so the preferences dialog doesn't raise
        NotImplementedError.
        """
        # If the actual plugin instance exists and provides a helper, use it
        try:
            if getattr(self, 'actual_plugin_', None) and hasattr(self.actual_plugin_, 'show_kobo_config'):
                try:
                    self.actual_plugin_.show_kobo_config()
                    return
                except Exception:
                    pass
        except Exception:
            pass

        # Fallback: show an informational dialog
        try:
            from qt.core import QMessageBox
            QMessageBox.information(parent, self.name, 'This plugin has no additional settings. Use the KoboTouch driver configuration instead.')
        except Exception:
            # Last resort: call base implementation which may raise, but we've tried
            try:
                return super(KoboTouchConfigButton, self).do_user_config(parent)
            except Exception:
                return

    def initialize(self):
        return super().initialize()
