#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class AIConfig(InterfaceActionBase):
    name = 'AI Config'
    description = 'Quick access to AI settings'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 0, 0)
    minimum_calibre_version = (8, 16, 2)
    actual_plugin = 'calibre_plugins.ai_config.action:AIConfigAction'

    def is_customizable(self):
        return False

    def initialize(self):
        # Call parent initialize first to register the plugin with calibre
        result = super().initialize()

        try:
            from calibre.utils.zipfile import ZipFile
            from . import common_icons
            import os

            resources = {}
            icon_paths = [
                'images/iconplugin_dark.png',
                'images/iconplugin_light.png',
            ]
            with ZipFile(self.plugin_path, 'r') as zf:
                for p in icon_paths:
                    try:
                        with zf.open(p, 'r') as f:
                            resources[p] = f.read()
                    except Exception:
                        pass
            common_icons.set_plugin_icon_resources(self.name, resources)
        except Exception:
            # non-fatal: don't prevent plugin loading if we cannot extract icons
            pass

        return result
