#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Cantonese language translations for Ask AI Plugin.
"""

from ..models.base import BaseTranslation, TranslationRegistry, AIProvider


@TranslationRegistry.register
class CantoneseTranslation(BaseTranslation):
    """Cantonese language translation."""
    
    @property
    def code(self) -> str:
        return "yue"
    
    @property
    def name(self) -> str:
        return "粵語"
    
    @property
    def default_template(self) -> str:
        return '關於本書 "{title}": 作者: {author}, 出版社: {publisher}, 出版年份: {pubyear}, 語言: {language}, 系列: {series}, 我嘅問題係: {query}'
    
    @property
    def suggestion_template(self) -> str:
        return """你係一個專業嘅書評家。對於「{title}」這本由{author}寫嘅書，出版語言係{language}，生成一個有見地嘅問題，幫助讀者更加理解這本書嘅核心思想、實踐應用或者獨特觀點。規則：1. 只返回問題本身，唔使介紹或解釋 2. 將焦點放在書嘅內容上，唔係標題 3. 令問題具有實用性同啟發性 4. 保持精簡（30-200字） 5. 發揮創意，就算係同一本書，每次都要生成唔同嘅問題"""
    
    @property
    def multi_book_default_template(self) -> str:
        return """以下係關於多本書嘅信息：{books_metadata} 用戶問題：{query} 請基於以上書籍信息回答問題。"""
    
    @property
    def translations(self) -> dict:
        return {
            # 插件信息
            'plugin_name': 'Ask AI Plugin',
            'plugin_desc': '用AI問書嘅問題',
            
            # UI - 標籤同區域
            'config_title': '設定',
            'general_tab': '一般',
            'ai_models': '人工智能',
            'shortcuts': '快捷鍵',
            'about': '關於',
            'metadata': '元數據',
            
            # UI - 按鈕同操作
            'ok_button': '確定',
            'save_button': '儲存',
            'send_button': '發送',
            'stop_button': '停止',
            'suggest_button': '隨機問題',
            'copy_response': '複製回答',
            'copy_question_response': '複製問答',
            'export_pdf': '導出 PDF',
            'export_current_qa': '導出當前問答',
            'export_history': '匯出歷史記錄',
            
            # 匯出設定
            'export_settings': '匯出設定',
            'enable_default_export_folder': '匯出到預設資料夾',
            'no_folder_selected': '未揀資料夾',
            'browse': '瀏覽...',
            'select_export_folder': '揀匯出資料夾',
            
            # 按鈕文字同選單項目
            'copy_response_btn': '複製回答',
            'copy_qa_btn': '複製問答',
            'export_current_btn': '匯出問答為PDF',
            'export_history_btn': '匯出歷史記錄為PDF',
            'copy_mode_response': '回答',
            'copy_mode_qa': '問答',
            'export_mode_current': '當前問答',
            'export_mode_history': '歷史記錄',
            
            # PDF匯出相關
            'model_provider': '提供商',
            'model_name': '模型',
            'model_api_url': 'API基礎URL',
            'pdf_model_info': 'AI模型資訊',
            'pdf_software': '軟件',
            
            'export_all_history_dialog_title': '匯出所有歷史記錄為PDF',
            'export_all_history_title': '所有問答歷史記錄',
            'export_history_insufficient': '需要至少兩條歷史記錄先可以導出。',
            'history_record': '記錄',
            'question_label': '問題',
            'answer_label': '回答',
            'default_ai': '預設AI',
            'export_time': '導出時間',
            'total_records': '總記錄數',
            'info': '資訊',
            'yes': '係',
            'no': '唔係',
            'no_book_selected_title': '未選擇書籍',
            'no_book_selected_message': '請先選擇一本書先至提問。',
            'set_default_ai_title': '設定預設AI',
            'set_default_ai_message': '你已切換到「{0}」。係唔係將佢設為預設AI以用於未來查詢？',
            'set_default_ai_success': '預設AI已設定為「{0}」。',
            'copied': '已複製！',
            'pdf_exported': 'PDF 已導出！',
            'export_pdf_dialog_title': '導出為 PDF',
            'export_pdf_error': 'PDF 導出錯誤：{0}',
            'no_question': '冗問題',
            'no_response': '冗回應',
            'saved': '已儲存',
            'close_button': '關閉',
            'open_local_tutorial': '打開本地教程',
            'tutorial_open_failed': '打開教程失敗',
            'tutorial': '教程',
            
            # UI - 設定欄位
            'token_label': 'API金鑰:',
            'api_key_label': 'API金鑰:',
            'model_label': '模型:',
            'language_label': '語言:',
            'language_label_old': '語言',
            'base_url_label': '基礎URL:',
            'base_url_placeholder': '預設: {default_api_base_url}',
            'shortcut': '快捷鍵',
            'shortcut_open_dialog': '開對話框',
            'shortcut_enter': 'Ctrl + Enter',
            'shortcut_return': 'Command + Return',
            'using_model': '模型',
            'action': '操作',
            'reset_button': '重置',
            'prompt_template': '提示模板',
            'ask_prompts': '問題提示',
            'random_questions_prompts': '隨機問題提示',
            'display': '顯示',
            
            # UI - 對話框元素
            'input_placeholder': '輸入你嘅問題...',
            'response_placeholder': '回答即將到來...',
            
            # UI - 選單項目
            'menu_title': '問問題',
            'menu_ask': '問',
            
            # UI - 狀態消息
            'loading': '載入緊',
            'loading_text': '問緊問題',
            'save_success': '設定已儲存',
            'sending': '發送緊...',
            'requesting': '請求緊',
            'formatting': '請求成功，格式化緊',
            
            # UI - 模型列表功能
            'load_models': '載入模型',
            'use_custom_model': '使用自訂模型名',
            'custom_model_placeholder': '輸入自訂模型名',
            'model_placeholder': '請先載入模型',
            'models_loaded': '成功載入 {count} 個模型',
            'load_models_failed': '載入模型失敗：{error}',
            'model_list_not_supported': '呢個提供商唔支援自動獲取模型列表',
            'api_key_required': '請先輸入 API Key',
            'invalid_params': '無效參數',
            'warning': '警告',
            'success': '成功',
            'error': '錯誤',
            
            # 元數據欄位
            'metadata_title': '標題',
            'metadata_authors': '作者',
            'metadata_publisher': '出版社',
            'metadata_pubyear': '出版年份',
            'metadata_language': '語言',
            'metadata_series': '系列',
            'no_metadata': '冇元數據',
            'no_series': '冇系列',
            'unknown': '未知',

            # 多本書功能
            'books_unit': ' 本書',
            'new_conversation': '新對話',
            'single_book': '單本書',
            'multi_book': '多本書',
            'deleted': '已刪除',
            'history': '歷史記錄',
            'no_history': '冇歷史記錄',
            'empty_question_placeholder': '（冇問題）',
            'history_ai_unavailable': '呢個AI已經從配置中刪除咗',
            'clear_current_book_history': '清空當前書籍歷史記錄',
            'confirm_clear_book_history': '確定要清空以下書籍所有歷史記錄嘅？\n{book_titles}',
            'confirm': '確認',
            'history_cleared': '已清空 {deleted_count} 條歷史記錄。',
            'multi_book_template_label': '多本書提示詞範本:',
            'multi_book_placeholder_hint': '用 {books_metadata} 作為書籍資訊，{query} 作為用戶問題',
            
            # 錯誤消息
            'network_error': '網絡錯誤',
            'request_timeout': '請求超時',
            'request_failed': '請求失敗',
            'question_too_long': '問題太長',
            'auth_token_required_title': '需要AI服務',
            'auth_token_required_message': '請在外掛程式配置中設定有效的AI服務。',
            'open_configuration': '打開配置',
            'cancel': '取消',
            "invalid_default_ai_title": "無效嘅預設人工智能",
            "invalid_default_ai_message": "預設嘅人工智能 \"{default_ai}\" 未有正確設定。\n\n你想轉用 \"{first_ai}\" 嗎？",
            "switch_to_ai": "轉用 {ai}",
            "keep_current": "保留目前",
            'error_preparing_request': '請求準備失敗',
            'empty_suggestion': '空建議',
            'process_suggestion_error': '處理建議時出錯',
            'unknown_error': '未知錯誤',
            'unknown_model': '未知模型: {model_name}',
            'suggestion_error': '建議錯誤',
            'auth_error_403': '拒絕訪問',
            'rate_limit': '請求太多',
            'invalid_json': '無效嘅JSON',
            'template_error': '模板錯誤',
            'no_model_configured': '未配置AI模型。請在設定中配置AI模型。',
            'no_ai_configured_title': '未配置AI',
            'no_ai_configured_message': '歡迎使用！要開始對書籍提問，你需要先配置一個AI提供商。\n\n推薦新手選擇：\n• Nvidia AI - 只需電話號即可獲取半年免費API訪問權限（無需綁定信用卡）\n• Ollama - 在你的電腦上本地執行AI模型（完全免費且隱私）\n\n是否而家打開外掛程式配置來設定AI提供商？',
            'open_settings': '外掛程式配置',
            'ask_anyway': '仍要詢問',
            'later': '稍後',
            'reset_all_data': '重置所有資料',
            'reset_all_data_warning': '這將會刪除所有API密鑰、提示詞模板和本地歷史記錄。你的語言偏好將被保留。請慎重操作。',
            'reset_all_data_confirm_title': '確認重置',
            'reset_all_data_confirm_message': '你確定要將外掛程式重置為初始狀態嗎？\n\n這將永久刪除：\n• 所有API密鑰\n• 所有自定義提示詞模板\n• 所有對話歷史記錄\n• 所有外掛程式設定（語言偏好將被保留）\n\n此操作無法撤銷！',
            'reset_all_data_success': '所有外掛程式資料已成功重置。請重新啟動calibre以使更改生效。',
            'reset_all_data_failed': '重置外掛程式資料失敗：{error}',
            'random_question_error': '生成隨機問題時出錯',
            'clear_history_failed': '清除歷史失敗',
            'clear_history_not_supported': '而家唔支持清除單本書嘅歷史記錄',
            'missing_required_config': '缺少必要嘅設定: {key}。請檢查你嘅設定。',
            'api_key_too_short': 'API金鑰太短。請檢查並輸入完整嘅金鑰。',
            
            # API回應處理
            'api_request_failed': 'API請求失敗: {error}',
            'api_content_extraction_failed': '無法從API回應中提取內容',
            'api_invalid_response': '收到嘅API回應無效',
            'api_unknown_error': '未知錯誤: {error}',
            
            # 流式回應處理
            'stream_response_code': '流式回應狀態碼: {code}',
            'stream_continue_prompt': '繼續你嘅上一個回應，唔使重複已經提供嘅內容。',
            'stream_continue_code_blocks': '你嘅上一個回應有未關閉嘅代碼塊。繼續並完成呢啲代碼塊。',
            'stream_continue_parentheses': '你嘅上一個回應有未關閉嘅括號。繼續並確保所有括號都正確關閉。',
            'stream_continue_interrupted': '你嘅上一個回應似乎被中斷咗。繼續並完成你嘅最後一個思考或解釋。',
            'stream_timeout_error': '流式傳輸喺60秒內冇收到新嘅內容，可能係連接問題。',
            
            # API錯誤消息
            'api_version_model_error': 'API版本或模型名稱錯誤: {message}\n\n請更新API基礎URL為"{base_url}"，以及模型為"{model}"或在設定中添加其他可用模型。',
            'api_format_error': 'API請求格式錯誤: {message}',
            'api_key_invalid': '無效或未授權嘅API金鑰: {message}\n\n請檢查你嘅API金鑰並確保已開啟API訪問。',
            'api_rate_limit': '超出請求限制，請稍後再試\n\n你可能超出咗免費配額。呢可能係因為:\n1. 每分鐘請求太多\n2. 每日請求太多\n3. 每分鐘輸入嘅令牌太多',
            
            # 設定錯誤
            'missing_config_key': '缺少必要嘅設定鍵: {key}',
            'api_base_url_required': '需要API基礎URL',
            'model_name_required': '需要模型名稱',
            'api_key_empty': 'API金鑰為空。請輸入有效嘅API金鑰。',
            
            # 模型列表獲取
            'fetching_models_from': '正在從 {url} 獲取模型',
            'successfully_fetched_models': '成功獲取 {count} 個 {provider} 模型',
            'failed_to_fetch_models': '獲取模型失敗：{error}',
            
            # 關於信息
            'author_name': 'Sheldon',
            'user_manual': '用戶手冊',
            'about_plugin': '點解揀 Ask AI Plugin？',
            'learn_how_to_use': '點樣用',
            'email': 'iMessage',
            
            # 模型特定設定
            'model_display_name_grok': 'Grok(x.AI)',
            'model_display_name_gemini': 'Gemini(Google)',
            'model_display_name_deepseek': 'Deepseek',
            'model_display_name_custom': '自訂',
            'model_enable_streaming': '啟用流式傳輸',
            
            # AI 切換器
            'current_ai': '當前 AI',
            'no_configured_models': '未配置 AI - 請在設定中配置',
            
            # 提供商特定信息
            'nvidia_free_info': '💡 新用戶有 6 個月免費 API 訪問 - 唔使信用卡',
            
            # 一般系統消息
            'default_system_message': '你係一個書籍分析專家。你嘅任務係通過提供有見地嘅問題同分析，幫助用戶更好咁理解書籍。',

            # 請求超時設定
            'request_timeout_label': '請求超時:',
            'seconds': '秒',
            'request_timeout_error': '請求超時。而家嘅超時時間：{timeout} 秒',
            
            # 並行 AI 設定
            'parallel_ai_count_label': '並行 AI 數量:',
            'parallel_ai_count_tooltip': '同時查詢嘅 AI 模型數量 (1-2 可用，3-4 即將推出)',
            'parallel_ai_notice': '注意：呢個只影響發送問題。隨機問題總係用單個 AI。',
            'suggest_maximize': '貼士：最大化窗口，用 3 個 AI 睇得更好',
            'ai_panel_label': 'AI {index}:',
            'no_ai_available': '呢個面板冇可用嘅 AI',
            'add_more_ai_providers': '請喺設定中添加更多 AI 提供商',
            'select_ai': '-- 選擇 AI --',
            'select_model': '-- 切換 Model --',
            'request_model_list': '請請求模型列表',
            'coming_soon': '即將推出',
            'advanced_feature_tooltip': '呢個功能開發緊。請留意更新！',
            
            # PDF 導出部分標題
            'pdf_book_metadata': '書籍元數據',
            'pdf_question': '問題',
            'pdf_answer': '回答',
            'pdf_ai_model_info': 'AI 模型信息',
            'pdf_generated_by': '由...生成',
            'pdf_provider': '提供商',
            'pdf_model': '模型',
            'pdf_api_base_url': 'API 基礎 URL',
            'pdf_panel': '面板',
            'pdf_plugin': '插件',
            'pdf_github': 'GitHub',
            'pdf_software': '軟件',
            'pdf_generated_time': '生成時間',
            'default_ai_mismatch_title': '預設 AI 已更改',
            'default_ai_mismatch_message': '配置中嘅預設 AI 已經改咗做 "{default_ai}",\n但係而家嘅對話框用緊 "{current_ai}"。\n\n你想唔想切換到新嘅預設 AI？',
            'discard_changes': '放棄更改',
            'empty_response': '收到咗 API 嘅空回應',
            'empty_response_after_filter': '過濾 think 標籤後回應係空嘅',
            'error_401': 'API 密鑰認證失敗。請檢查：API 密鑰正確、帳戶有足夠餘額、API 密鑰未過期。',
            'error_403': '拒絕訪問。請檢查：API 密鑰有足夠權限、冇地區訪問限制。',
            'error_404': '搵唔到 API 端點。請檢查 API Base URL 配置係咪正確。',
            'error_429': '請求太多，達到速率限制。請稍後再試。',
            'error_5xx': '伺服器錯誤。請稍後再試或者檢查服務提供商狀態。',
            'error_network': '網絡連接失敗。請檢查網絡連接、代理設置或者防火牆配置。',
            'error_unknown': '未知錯誤。',
            'gemini_geo_restriction': 'Gemini API 喺你嘅地區唔可用。請試吓：\n1. 用 VPN 從支持嘅地區連接\n2. 用其他 AI 提供商（OpenAI、Anthropic、DeepSeek 等）\n3. 檢查 Google AI Studio 嘅地區可用性',
            'load_models_list': '載入模型列表',
            'loading_models_text': '載入緊模型',
            'model_test_success': '模型測試成功！配置已保存。',
            'models_loaded_with_selection': '成功載入咗 {count} 個模型。\n已選模型：{model}',
            'ollama_model_not_available': '模型 "{model}" 唔可用。請檢查：\n1. 模型啟動咗未？運行：ollama run {model}\n2. 模型名稱啱唔啱？\n3. 模型下載咗未？運行：ollama pull {model}',
            'ollama_service_not_running': 'Ollama 服務未運行。請先啟動 Ollama 服務。',
            'ollama_service_timeout': 'Ollama 服務連接超時。請檢查服務係咪正常運行。',
            'reset_ai_confirm_message': '準備將 {ai_name} 重置為預設狀態。\n\n呢個會清除：\n• API 密鑰\n• 自訂模型名稱\n• 其他已配置參數\n\n繼續？',
            'reset_ai_confirm_title': '確認重置',
            'reset_current_ai': '將當前 AI 重置為預設',
            'reset_tooltip': '將當前 AI 重置為預設值',
            'save_and_close': '保存並關閉',
            'skip': '跳過',
            'technical_details': '技術詳情',
            'test_current_model': '測試當前模型',
            'test_model_button': '測試模型',
            'test_model_prompt': '模型載入成功！你想唔想測試已選模型 "{model}"？',
            'unsaved_changes_message': '你有未保存嘅更改。你想點做？',
            'unsaved_changes_title': '未保存嘅更改',


            'pdf_info_not_available': '信息不可用',
            'auth_error_401': '未授權',
            'avoid_repeat_question': '請用另一個問題',
            'book_title_check': '需要書名',
            'empty_answer': '空答案',
            'invalid_response': '無效回應',
            'random_question_success': '成功生成隨機問題！',


        }