from PyQt5.Qt import (QWidget, QVBoxLayout, QLabel, QSpinBox,
                      QGroupBox, QFormLayout)
from calibre.utils.config import JSONConfig

# This is where the plugin settings are stored
prefs = JSONConfig('plugins/n_pages_previews')

try:
    load_translations()
except NameError:
    pass  # load_translations() added in calibre 1.9

# Set defaults
prefs.defaults['num_pages'] = 15
prefs.defaults['image_width'] = 800
prefs.defaults['image_quality'] = 85
prefs.defaults['preview_zoom'] = 100  # Zoom percentage (20-1000%)


class ConfigWidget(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        # Title
        title_label = QLabel(_('<h2>N-Pages Previews Configuration</h2>'))
        self.layout.addWidget(title_label)

        # Settings group
        settings_group = QGroupBox(_('Preview Settings'))
        settings_layout = QFormLayout()
        settings_group.setLayout(settings_layout)

        # Number of pages
        self.num_pages_spin = QSpinBox()
        self.num_pages_spin.setMinimum(1)
        self.num_pages_spin.setMaximum(100)
        self.num_pages_spin.setValue(prefs['num_pages'])
        settings_layout.addRow(_('Number of pages to preview:'), self.num_pages_spin)

        # Image width
        self.image_width_spin = QSpinBox()
        self.image_width_spin.setMinimum(400)
        self.image_width_spin.setMaximum(2000)
        self.image_width_spin.setSingleStep(100)
        self.image_width_spin.setValue(prefs['image_width'])
        settings_layout.addRow(_('Image width (pixels):'), self.image_width_spin)

        # Image quality
        self.image_quality_spin = QSpinBox()
        self.image_quality_spin.setMinimum(50)
        self.image_quality_spin.setMaximum(100)
        self.image_quality_spin.setValue(prefs['image_quality'])
        settings_layout.addRow(_('JPEG quality (50-100):'), self.image_quality_spin)

        self.layout.addWidget(settings_group)
        self.layout.addStretch()

    def save_settings(self):
        prefs['num_pages'] = self.num_pages_spin.value()
        prefs['image_width'] = self.image_width_spin.value()
        prefs['image_quality'] = self.image_quality_spin.value()
