# N-Pages Previews Plugin for Calibre

A Calibre plugin that generates multi-page preview images from PDF books.

## Features

- Generate preview images of first N pages (default: 15)
- Medium resolution preview images
- Cached images stored in book folder (`.previews` subdirectory)
- Async interface with progress indicators
- Batch generation for multiple books
- Configurable settings (number of pages, image width, quality)
- **Zoom slider** with persistent zoom level (20%-1000%)
- **Responsive column layout** - automatically adjusts to panel width
- **No external dependencies** - uses Calibre's built-in PDF rendering

## Installation

### Method 1: From ZIP file (Recommended for testing)

1. Package the plugin:

   ```bash
   cd code/calibre/n-pages-previews
   zip -r ../n-pages-previews.zip . -x "*.pyc" -x "*__pycache__*" -x "*.DS_Store" -x ".*"
   ```

   **Important:** Note the `.` - we zip from INSIDE the plugin directory so `__init__.py` is at the root of the ZIP.

2. In Calibre:
   - Go to **Preferences** → **Plugins** → **Load plugin from file**
   - Select the `n-pages-previews.zip` file
   - Click "Yes" to confirm installation
   - **Restart Calibre** (required!)

### Method 2: Quick Development Cycle

For rapid testing during development:

```bash
# Close Calibre, package plugin, and restart
calibre -s
sleep 2
cd /Users/sno/Data/snogit/snowmain1/code/calibre/n-pages-previews
zip -r ../n-pages-previews.zip . -x "*.pyc" -x "__pycache__/*"
calibre
```

Then go to Preferences → Plugins → Load plugin from file → select the ZIP

## Requirements

The plugin requires one of the following PDF rendering libraries:

### Option 1: PyMuPDF (Recommended)

```bash
pip install PyMuPDF
```

### Option 2: pdf2image (Fallback)

```bash
pip install pdf2image
# Also requires poppler-utils installed on your system
```

**Note:** The plugin will check for these dependencies and show a helpful error message if they're missing. You can install them using Calibre's Python.

### Finding and Using Calibre's Python

To install dependencies for Calibre:

```bash
# Find Calibre's Python executable
calibre-debug -c "import sys; print(sys.executable)"

# This will output something like:
# /Applications/calibre.app/Contents/MacOS/calibre (on macOS)
# or a Python path on Linux/Windows

# Then install using calibre-debug
calibre-debug -c "import pip; pip.main(['install', 'PyMuPDF'])"
```

**Automatic Dependency Check:** When you try to use the plugin without required libraries, you'll see a friendly error dialog with installation instructions. No need to panic!

## Usage

**Important:** After installation, you'll see a "N-Pages Previews" button in the toolbar. Click it to open the menu.

### Quick Preview Panel (Recommended for Kids' Books!)

1. Click **N-Pages Previews** → **Toggle Preview Panel**
2. A side panel appears showing thumbnail previews
3. Click through different books - previews update automatically!
4. Click any thumbnail to open full preview dialog at that page
5. Perfect for quickly evaluating picture books!

#### Zoom Control

- Use the **Zoom slider** at the top of the preview panel to adjust thumbnail size (20%-1000%)
- The zoom level is automatically saved and remembered between sessions
- The column layout automatically adjusts based on zoom level:
  - At lower zoom levels (20%-80%), more columns fit side by side for quick overview
  - At medium zoom levels (100%-200%), comfortable viewing with 1-2 columns
  - At higher zoom levels (300%-1000%), single column with very detailed previews
  - Resize the panel width to see columns reflow automatically

### Show Full Preview Dialog

1. Select a book with PDF format in your library
2. Click the **N-Pages Previews** button in the toolbar
3. Select **Show Preview Dialog** from the menu
4. A dialog will open showing all preview pages

### Batch Generate Previews

1. Select one or more books with PDF format
2. Click the **N-Pages Previews** button
3. Select **Generate Preview for Selected Books**
4. Click "Start" in the dialog
5. Monitor progress in the log

### Configuration

1. Click **N-Pages Previews** → **Configure**
2. Adjust settings:
   - **Number of pages**: How many pages to preview (1-100)
   - **Image width**: Target width in pixels (400-2000)
   - **JPEG quality**: Image quality (50-100)
3. Click "OK" to save

## Cache Management

- Preview images are cached in `<book_folder>/.previews/`
- Cache keys are based on PDF path, modification time, and settings
- If you change settings, new previews will be generated
- Cached images are automatically reused when settings haven't changed

## Troubleshooting

### Plugin doesn't appear after installation

- Make sure you restarted Calibre after installation
- Check Preferences → Plugins → User interface actions for "N-Pages Previews"

### "No PDF rendering library available" error

- Install PyMuPDF: `pip install PyMuPDF`
- Make sure it's installed in Calibre's Python environment

### Previews not generating

- Ensure the book has PDF format
- Check that the PDF file exists in the library folder
- Look at the log in batch generation dialog for specific errors

### Finding Calibre's Python

To find which Python Calibre uses:

```bash
calibre-debug -c "import sys; print(sys.executable)"
```

Then install libraries with:

```bash
/path/to/calibre/python -m pip install PyMuPDF
```

## Development

File structure:

```
n-pages-previews/
├── __init__.py           # Plugin entry point
├── ui.py                 # Main UI action
├── config.py             # Configuration widget and settings
├── main.py               # Preview dialog (single book)
├── generator.py          # Batch generation dialog
├── preview_generator.py  # Core PDF → image logic
├── preview_panel.py      # Dockable side panel with zoom control
└── README.md            # This file
```

## License

MIT License - Feel free to modify and distribute
