from calibre.customize import InterfaceActionBase


class NPagesPreviewsPlugin(InterfaceActionBase):
    """
    Multi-page preview generator for Calibre books
    """
    name = 'N-Pages Previews'
    description = 'Generate preview images of first N pages from PDFs'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Your Name'
    version = (1, 0, 0)
    minimum_calibre_version = (5, 0, 0)

    actual_plugin = 'calibre_plugins.n_pages_previews.ui:NPagesPreviewsAction'
    resources = ('images/icon.png',)

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.n_pages_previews.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()


def get_resources(name):
    """Load a resource file from the plugin"""
    import os
    import pkgutil
    import zipfile

    # Prefer pkgutil so resources load correctly from Calibre's zip importer
    data = pkgutil.get_data(__name__, name)
    if data is not None:
        return data
    # Try reading directly from the installed zip (Calibre loads plugins as zip files)
    try:
        file_path = globals().get('__file__', '')
        if file_path and '.zip' in file_path:
            zip_path, _, _ = file_path.partition('.zip')
            zip_path += '.zip'
            if os.path.exists(zip_path):
                with zipfile.ZipFile(zip_path) as zf:
                    if name in zf.namelist():
                        return zf.read(name)
    except Exception:
        # Fall through to filesystem fallback if direct zip read fails
        pass

    try:
        # Fallback: try to load from filesystem (useful during local dev)
        plugin_dir = os.path.dirname(os.path.abspath(__file__))
        path = os.path.join(plugin_dir, name)
        if os.path.exists(path):
            with open(path, 'rb') as f:
                return f.read()
    except:
        pass

    return None
