# Icon Specifications for N-Pages Previews Plugin

## Menu Button Icon

To add a custom icon for the "N-Pages Previews" toolbar button:

### Icon Specifications

- **Format**: PNG with transparency
- **Size**: 64x64 pixels (will be auto-scaled by Calibre)
- **Recommended sizes**: 16x16, 24x24, 32x32, 48x48, 64x64 (for different DPI settings)
- **Color scheme**: Use colors that work on both light and dark themes
- **Style**: Simple, clear, recognizable at small sizes

### Suggested Design

The icon should represent "multiple pages" or "preview/thumbnails". Some ideas:

1. **Multiple stacked pages** - 3-4 overlapping rectangles suggesting pages
2. **Grid of thumbnails** - 2x2 or 3x3 grid of small squares
3. **Open book with preview** - Book outline with small page previews visible
4. **Pages fan** - Pages spreading out like a fan

### File Location

Save the icon as:
```
code/calibre/n-pages-previews/images/icon.png
```

Create the `images` directory:
```bash
mkdir -p code/calibre/n-pages-previews/images
```

### How to Add the Icon

1. Create your icon file (PNG, 64x64)
2. Save it to: `code/calibre/n-pages-previews/images/icon.png`
3. The plugin will automatically use it (already configured in ui.py)
4. Rebuild the ZIP:
   ```bash
   cd code/calibre/n-pages-previews
   zip -r ../n-pages-previews.zip . -x "*.pyc" -x "*__pycache__*" -x "*.DS_Store" -x ".*"
   ```
5. Reload the plugin in Calibre

### Current Icon Code

The plugin currently uses a fallback icon. Once you add `images/icon.png`, it will automatically be used:

```python
def get_icon():
    """Get icon for the plugin"""
    try:
        # Use Calibre's built-in icon loading
        from calibre.utils.config import dynamic
        return dynamic.get_icons('book.png')  # Fallback
    except:
        from PyQt5.Qt import QIcon
        return QIcon()
```

### Example Icon Ideas

**Simple stacked pages:**
```
┌────┐
│┌───┤
││┌──┤
│││  │
```

**Grid thumbnails (2x2):**
```
┌─┬─┐
├─┼─┤
└─┴─┘
```

**Book with previews:**
```
   ┌─┬─┐
  ┌┤ │ │
  │├─┼─┤
  └┤ │ │
   └─┴─┘
```

Once you provide the icon, just let me know and I'll update the code to load it from the images folder!
