#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Russian language translations for Ask AI Plugin.
"""

from ..models.base import BaseTranslation, TranslationRegistry, AIProvider


@TranslationRegistry.register
class RussianTranslation(BaseTranslation):
    """Russian language translation."""
    
    @property
    def code(self) -> str:
        return "ru"
    
    @property
    def name(self) -> str:
        return "Русский"
    
    @property
    def default_template(self) -> str:
        return 'О книге "{title}": Автор: {author}, Издательство: {publisher}, Год издания: {pubyear}, книга на language: {language}, Серия: {series}, Мой вопрос: {query}'
    
    @property
    def suggestion_template(self) -> str:
        return """Вы эксперт в области рецензий на книги. Для книги "{title}" автора {author}, публикация язык {language}, сгенерируйте ОДИН проницательный вопрос, который поможет читателям лучше понять книгу. Правила: 1. Верните ТОЛЬКО вопрос, без введения или объяснения 2. Сосредоточьтесь на содержании книги, а не только на названии 3. Сделайте вопрос практичным и провокационным 4. Сдерживайте его кратким (30-200 слов) 5. Будьте креативны и генерируйте разные вопросы каждый раз, даже для одной и той же книги"""
    
    @property
    def multi_book_default_template(self) -> str:
        return """Вот информация о нескольких книгах: {books_metadata} Вопрос пользователя: {query} Пожалуйста, ответьте на вопрос на основе приведенной выше информации о книгах."""
    
    @property
    def translations(self) -> dict:
        return {
            # Информация о плагине
            'plugin_name': 'Ask AI Plugin',
            'plugin_desc': 'Задавайте вопросы о книге с помощью ИИ',
            
            # UI - Вкладки и разделы
            'config_title': 'Конфигурация',
            'general_tab': 'Общие',
            'ai_models': 'ИИ',
            'shortcuts': 'Горячие клавиши',
            'about': 'О программе',
            'metadata': 'Метаданные',
            
            # UI - Кнопки и действия
            'ok_button': 'OK',
            'save_button': 'Сохранить',
            'send_button': 'Отправить',
            'stop_button': 'Остановить',
            'suggest_button': 'Случайный вопрос',
            'copy_response': 'Копировать ответ',
            'copy_question_response': 'Копировать В&&О',
            'export_pdf': 'Экспортировать PDF',
            'export_current_qa': 'Экспортировать текущий В&О',
            'export_history': 'Экспортировать историю',
            'export_all_history_dialog_title': 'Экспортировать всю историю в PDF',
            'export_all_history_title': 'ВСЯ ИСТОРИЯ В&О',
            'export_history_insufficient': 'Для экспорта требуется минимум 2 записи истории.',
            'history_record': 'Запись',
            'question_label': 'Вопрос',
            'answer_label': 'Ответ',
            'default_ai': 'ИИ по умолчанию',
            'export_time': 'Экспортировано',
            'total_records': 'Всего записей',
            'info': 'Информация',
            'yes': 'Да',
            'no': 'Нет',
            'no_book_selected_title': 'Книга Не Выбрана',
            'no_book_selected_message': 'Пожалуйста, выберите книгу перед тем, как задавать вопросы.',
            'set_default_ai_title': 'Установить ИИ по Умолчанию',
            'set_default_ai_message': 'Вы переключились на "{0}". Хотите установить её как ИИ по умолчанию для будущих запросов?',
            'set_default_ai_success': 'ИИ по умолчанию установлена на "{0}".',
            'copied': 'Скопировано!',
            'pdf_exported': 'PDF экспортирован!',
            'export_pdf_dialog_title': 'Экспортировать в PDF',
            'export_pdf_error': 'Ошибка при экспорте PDF: {0}',
            'no_question': 'Нет вопроса',
            'saved': 'Сохранено',
            'close_button': 'Закрыть',
            
            # UI - Поля конфигурации
            'token_label': 'Ключ API:',
            'api_key_label': 'Ключ API:',
            'model_label': 'Модель:',
            'language_label': 'Язык:',
            'language_label_old': 'Язык',
            'base_url_label': 'Базовый URL:',
            'base_url_placeholder': 'По умолчанию: {default_api_base_url}',
            'shortcut': 'Горячая клавиша',
            'shortcut_open_dialog': 'Открыть диалог',
            'shortcut_enter': 'Ctrl + Enter',
            'shortcut_return': 'Command + Return',
            'using_model': 'Модель',
            'action': 'Действие',
            'reset_button': 'Сброс',
            'prompt_template': 'Шаблон подсказки',
            'ask_prompts': 'Подсказки для вопросов',
            'random_questions_prompts': 'Подсказки для случайных вопросов',
            'display': 'Отображение',
            
            # UI - Элементы диалога
            'input_placeholder': 'Введите ваш вопрос...',
            'response_placeholder': 'Ответ скоро появится...',
            
            # UI - Пункты меню
            'menu_title': 'Спросить',
            'menu_ask': 'Спросить {model}',
            
            # UI - Сообщения о состоянии
            'loading': 'Загрузка...',
            'loading_text': 'Задаю вопрос',
            'save_success': 'Настройки сохранены',
            'sending': 'Отправка...',
            'requesting': 'Запрос',
            'formatting': 'Запрос успешен, форматирование',
            
            # UI - Функция списка моделей
            'load_models': 'Загрузить модели',
            'use_custom_model': 'Использовать пользовательское имя модели',
            'custom_model_placeholder': 'Введите пользовательское имя модели',
            'model_placeholder': 'Пожалуйста, сначала загрузите модели',
            'models_loaded': 'Успешно загружено {count} моделей',
            'load_models_failed': 'Не удалось загрузить модели: {error}',
            'model_list_not_supported': 'Этот провайдер не поддерживает автоматическую загрузку списка моделей',
            'api_key_required': 'Пожалуйста, сначала введите API-ключ',
            'invalid_params': 'Недопустимые параметры',
            'warning': 'Предупреждение',
            'success': 'Успех',
            'error': 'Ошибка',
            
            # Поля метаданных
            'metadata_title': 'Название',
            'metadata_authors': 'Автор',
            'metadata_publisher': 'Издательство',
            'metadata_pubyear': 'Дата публикации',
            'metadata_language': 'Язык',
            'metadata_series': 'Серия',
            'no_metadata': 'Нет метаданных',
            'no_series': 'Нет серии',
            'unknown': 'Неизвестно',
            
            # Multi-book функция
            'books_unit': ' книги',
            'new_conversation': 'Новый диалог',
            'single_book': 'Одна книга',
            'multi_book': 'Несколько книг',
            'deleted': 'Удалено',
            'history': 'История',
            'no_history': 'Нет записей истории',
            'empty_question_placeholder': '(Нет вопроса)',
            'history_ai_unavailable': 'Этот ИИ был удален из конфигурации',
            'clear_current_book_history': 'Очистить историю текущей книги',
            'confirm_clear_book_history': 'Вы уверены, что хотите очистить всю историю для:\n{book_titles}?',
            'confirm': 'Подтвердить',
            'history_cleared': 'Удалено {deleted_count} записей истории.',
            'multi_book_template_label': 'Шаблон промпта для нескольких книг:',
            'multi_book_placeholder_hint': 'Используйте {books_metadata} для информации о книге, {query} для вопроса пользователя',
            
            # Сообщения об ошибках
            'network_error': 'Ошибка сети',
            'request_timeout': 'Тайм-аут запроса',
            'request_failed': 'Запрос не удался',
            'question_too_long': 'Вопрос слишком длинный',
            'auth_token_required_title': 'Требуется ключ API',
            'auth_token_required_message': 'Пожалуйста, установите действительный ключ API в конфигурации плагина.',
            'open_configuration': 'Открыть конфигурацию',
            'cancel': 'Отмена',
            'error_preparing_request': 'Ошибка подготовки запроса',
            'empty_suggestion': 'Пустое предложение',
            'process_suggestion_error': 'Ошибка обработки предложения',
            'unknown_error': 'Неизвестная ошибка',
            'unknown_model': 'Неизвестная модель: {model_name}',
            'suggestion_error': 'Ошибка предложения',
            'random_question_success': 'Случайный вопрос успешно сгенерирован!',
            'book_title_check': 'Требуется название книги',
            'avoid_repeat_question': 'Пожалуйста, используйте другой вопрос',
            'empty_answer': 'Пустой ответ',
            'invalid_response': 'Недействительный ответ',
            'auth_error_401': 'Не авторизован',
            'auth_error_403': 'Доступ запрещен',
            'rate_limit': 'Слишком много запросов',
            'invalid_json': 'Неверный JSON',
            'no_response': 'Нет ответа',
            'template_error': 'Ошибка шаблона',
            'no_model_configured': 'Модель ИИ не настроена. Пожалуйста, настройте модель ИИ в настройках.',
            'no_ai_configured_title': 'ИИ не настроен',
            'no_ai_configured_message': 'Добро пожаловать! Чтобы начать задавать вопросы о ваших книгах, вам нужно сначала настроить провайдера ИИ.\n\nРекомендуется для новичков:\n• Nvidia AI - Получите 6 месяцев БЕСПЛАТНОГО доступа к API только с номером телефона (кредитная карта не требуется)\n• Ollama - Запускайте модели ИИ локально на вашем компьютере (полностью бесплатно и конфиденциально)\n\nХотите открыть конфигурацию плагина, чтобы настроить провайдера ИИ сейчас?',
            'open_settings': 'Конфигурация плагина',
            'ask_anyway': 'Все равно спросить',
            'later': 'Позже',
            'reset_all_data': 'Сбросить все данные',
            'reset_all_data_warning': 'Это удалит все ключи API, шаблоны промптов и локальные записи истории. Ваши языковые настройки будут сохранены. Пожалуйста, продолжайте с осторожностью.',
            'reset_all_data_confirm_title': 'Подтвердить сброс',
            'reset_all_data_confirm_message': 'Вы уверены, что хотите сбросить плагин до исходного состояния?\n\nЭто навсегда удалит:\n• Все ключи API\n• Все пользовательские шаблоны промптов\n• Всю историю разговоров\n• Все настройки плагина (языковые настройки будут сохранены)\n\nЭто действие нельзя отменить!',
            'reset_all_data_success': 'Все данные плагина успешно сброшены. Пожалуйста, перезапустите calibre, чтобы изменения вступили в силу.',
            'reset_all_data_failed': 'Не удалось сбросить данные плагина: {error}',
            'random_question_error': 'Ошибка при генерации случайного вопроса',
            'clear_history_failed': 'Не удалось очистить историю',
            'clear_history_not_supported': 'Очистка истории для одной книги пока не поддерживается',
            'missing_required_config': 'Отсутствует обязательная конфигурация: {key}. Проверьте ваши настройки.',
            'api_key_too_short': 'Ключ API слишком короткий. Проверьте и введите полный ключ.',
            
            # Обработка ответов API
            'api_request_failed': 'Запрос API не удался: {error}',
            'api_content_extraction_failed': 'Не удалось извлечь содержимое из ответа API',
            'api_invalid_response': 'Не получен действительный ответ API',
            'api_unknown_error': 'Неизвестная ошибка: {error}',
            
            # Обработка потоковых ответов
            'stream_response_code': 'Код статуса потокового ответа: {code}',
            'stream_continue_prompt': 'Продолжите свой предыдущий ответ, не повторяя уже предоставленное содержимое.',
            'stream_continue_code_blocks': 'В вашем предыдущем ответе были незакрытые блоки кода. Продолжите и завершите эти блоки кода.',
            'stream_continue_parentheses': 'В вашем предыдущем ответе были незакрытые скобки. Продолжите и убедитесь, что все скобки правильно закрыты.',
            'stream_continue_interrupted': 'Кажется, ваш предыдущий ответ был прерван. Продолжите и завершите свою последнюю мысль или объяснение.',
            'stream_timeout_error': 'Потоковая передача не получала нового содержимого в течение 60 секунд, возможно, проблема с соединением.',
            
            # Сообщения об ошибках API
            'api_version_model_error': 'Ошибка версии API или названия модели: {message}\n\nОбновите базовый URL API на "{base_url}" и модель на "{model}" или другую доступную модель в настройках.',
            'api_format_error': 'Ошибка формата запроса API: {message}',
            'api_key_invalid': 'Недействительный или неавторизованный ключ API: {message}\n\nПроверьте свой ключ API и убедитесь, что доступ к API включен.',
            'api_rate_limit': 'Превышен лимит запросов, попробуйте позже\n\nВозможно, вы превысили свою бесплатную квоту использования. Это может быть связано с:\n1. Слишком много запросов в минуту\n2. Слишком много запросов в день\n3. Слишком много входных токенов в минуту',
            
            # Ошибки конфигурации
            'missing_config_key': 'Отсутствует обязательный ключ конфигурации: {key}',
            'api_base_url_required': 'Требуется базовый URL API',
            'model_name_required': 'Требуется название модели',
            'api_key_empty': 'Ключ API пуст. Введите действительный ключ API.',
            
            # Загрузка списка моделей
            'fetching_models_from': 'Загрузка моделей с {url}',
            'successfully_fetched_models': 'Успешно загружено {count} моделей {provider}',
            'failed_to_fetch_models': 'Не удалось загрузить модели: {error}',
            
            # Информация о программе
            'author_name': 'Sheldon',
            'user_manual': 'Руководство пользователя',
            'about_plugin': 'Почему Ask AI Plugin?',
            'learn_how_to_use': 'Как пользоваться',
            'email': 'iMessage',
            
            # Конфигурации специфичные для модели
            'model_display_name_grok': 'Grok(x.AI)',
            'model_display_name_gemini': 'Gemini(Google)',
            'model_display_name_deepseek': 'Deepseek',
            'model_display_name_custom': 'Пользовательский',
            'model_enable_streaming': 'Включить потоковую передачу',
            
            # AI Switcher
            'current_ai': 'Текущий ИИ',
            'no_configured_models': 'ИИ не настроен - Пожалуйста, настройте в настройках',

            # Provider specific info
            'nvidia_free_info': '💡 Новые пользователи получают 6 месяцев бесплатного доступа к API - Кредитная карта не требуется',
            
            # Общие системные сообщения
            'default_system_message': 'Вы эксперт по анализу книг. Ваша задача - помочь пользователям лучше понять книги, предоставляя проницательные вопросы и анализ.',

            # Request Timeout settings
            'request_timeout_label': 'Тайм-аут запроса:',
            'seconds': 'секунд',
            'request_timeout_error': 'Тайм-аут запроса истек. Текущий тайм-аут: {timeout} секунд',
            
            # Parallel AI settings
            'parallel_ai_count_label': 'Количество параллельных ИИ:',
            'parallel_ai_count_tooltip': 'Количество моделей ИИ для одновременного запроса (1-2 доступны, 3-4 скоро)',
            'parallel_ai_notice': 'Примечание: Это влияет только на отправку вопросов. Случайные вопросы всегда используют один ИИ.',
            'suggest_maximize': 'Совет: Разверните окно для лучшего просмотра с 3 ИИ',
            'ai_panel_label': 'ИИ {index}:',
            'no_ai_available': 'Нет доступного ИИ для этой панели',
            'add_more_ai_providers': 'Пожалуйста, добавьте больше провайдеров ИИ в настройках',
            'select_ai': '-- Выбрать ИИ --',
            'select_model': '-- Переключить Модель --',
            'request_model_list': 'Пожалуйста, запросите список моделей',
            'coming_soon': 'Скоро',
            'advanced_feature_tooltip': 'Эта функция находится в разработке. Следите за обновлениями!',

            # PDF export section titles
            'pdf_book_metadata': 'МЕТАДАННЫЕ КНИГИ',
            'pdf_question': 'ВОПРОС',
            'pdf_answer': 'ОТВЕТ',
            'pdf_ai_model_info': 'ИНФОРМАЦИЯ О МОДЕЛИ ИИ',
            'pdf_generated_by': 'СГЕНЕРИРОВАНО',
            'pdf_provider': 'Провайдер',
            'pdf_model': 'Модель',
            'pdf_api_base_url': 'Базовый URL API',
            'pdf_panel': 'Панель',
            'pdf_plugin': 'Плагин',
            'pdf_github': 'GitHub',
            'pdf_software': 'Программное обеспечение',
            'pdf_generated_time': 'Время генерации',
            'default_ai_mismatch_title': 'ИИ по Умолчанию Изменен',
            'default_ai_mismatch_message': 'ИИ по умолчанию в конфигурации был изменен на "{default_ai}",\nно текущий диалог использует "{current_ai}".\n\nХотите переключиться на новый ИИ по умолчанию?',
            'discard_changes': 'Отменить Изменения',
            'empty_response': 'Получен пустой ответ от API',
            'empty_response_after_filter': 'Ответ пуст после фильтрации тегов think',
            'error_401': 'Ошибка аутентификации API-ключа. Проверьте: API-ключ правильный, на счете достаточно средств, API-ключ не истек.',
            'error_403': 'Доступ запрещен. Проверьте: API-ключ имеет достаточные разрешения, нет региональных ограничений доступа.',
            'error_404': 'Конечная точка API не найдена. Проверьте правильность настройки базового URL API.',
            'error_429': 'Слишком много запросов, достигнут лимит скорости. Повторите попытку позже.',
            'error_5xx': 'Ошибка сервера. Повторите попытку позже или проверьте статус поставщика услуг.',
            'error_network': 'Ошибка сетевого подключения. Проверьте сетевое подключение, настройки прокси или конфигурацию брандмауэра.',
            'error_unknown': 'Неизвестная ошибка.',
            'gemini_geo_restriction': 'API Gemini недоступен в вашем регионе. Попробуйте:\n1. Используйте VPN для подключения из поддерживаемого региона\n2. Используйте других поставщиков ИИ (OpenAI, Anthropic, DeepSeek и т.д.)\n3. Проверьте Google AI Studio на предмет региональной доступности',
            'load_models_list': 'Загрузить Список Моделей',
            'loading_models_text': 'Загрузка моделей',
            'model_test_success': 'Тест модели успешен! Конфигурация сохранена.',
            'models_loaded_with_selection': 'Успешно загружено {count} моделей.\nВыбранная модель: {model}',
            'ollama_model_not_available': 'Модель "{model}" недоступна. Проверьте:\n1. Запущена ли модель? Выполните: ollama run {model}\n2. Правильно ли указано имя модели?\n3. Загружена ли модель? Выполните: ollama pull {model}',
            'ollama_service_not_running': 'Служба Ollama не запущена. Сначала запустите службу Ollama.',
            'ollama_service_timeout': 'Тайм-аут подключения к службе Ollama. Проверьте, правильно ли работает служба.',
            'reset_ai_confirm_message': 'Сброс {ai_name} до состояния по умолчанию.\n\nЭто очистит:\n• API-ключ\n• Пользовательское имя модели\n• Другие настроенные параметры\n\nПродолжить?',
            'reset_ai_confirm_title': 'Подтвердить Сброс',
            'reset_current_ai': 'Сбросить Текущий ИИ до Значений по Умолчанию',
            'reset_tooltip': 'Сбросить текущий ИИ до значений по умолчанию',
            'save_and_close': 'Сохранить и Закрыть',
            'skip': 'Пропустить',
            'technical_details': 'Технические Детали',
            'test_current_model': 'Тестировать Текущую Модель',
            'test_model_button': 'Тестировать Модель',
            'test_model_prompt': 'Модели успешно загружены! Хотите протестировать выбранную модель "{model}"?',
            'unsaved_changes_message': 'У вас есть несохраненные изменения. Что вы хотите сделать?',
            'unsaved_changes_title': 'Несохраненные Изменения',


            'pdf_info_not_available': 'Информация недоступна',
        }