# calibre_plugins/pdf_to_cbz/__init__.py

from calibre.customize import InterfaceActionBase
from calibre.utils.logging import default_log as log

class PDFtoCBZ(InterfaceActionBase):
    """
    Plugin principal : point d'entrée Calibre
    Fournit un menu avec les options PNG/JPG, DPI et compression.
    """
    name = 'PDFtoCBZ'
    description = 'Convertit les livres PDF en CBZ avec choix du format et compression'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'ShiZen'
    version = (4, 0, 0)
    minimum_calibre_version = (6, 0, 0)
    actual_plugin = 'calibre_plugins.pdf_to_cbz.ui:PDFtoCBZ'
    icon = 'images/plugin.png'

    # Options utilisateur par défaut
    options = {
        'output_format': 'jpg',     # png ou jpg
        'dpi': 200,                 # résolution par défaut
        'compression': 95,           # pour jpg, 0-100
        "method" : 1, # methode de gestion de tache
        "dimension" : 'comic : 17x26 cm'
    }

    def is_customizable(self):
        # Indique à Calibre que le plugin a un menu d’options
        return True

    def config_widget(self):
        """
        Renvoie le widget de configuration (géré par Calibre)
        Appelé quand l'utilisateur clique sur "Personnaliser le plugin".
        """
        log.info("pdftocbz: chargement config")
        from calibre_plugins.pdf_to_cbz.config import ConfigWidget
        #log.info("odfcbz: " + ConfigWidget(self.options) )
        return ConfigWidget(self.options)

    def save_settings(self, config_widget):
        """
        Sauvegarde les options choisies par l'utilisateur.
        """
        log.info("pdfcbz: save config")

        self.options['output_format'] = config_widget.format_var.currentText()
        self.options['dpi'] = int(config_widget.dpi_var.value())
        self.options['compression'] = int(config_widget.comp_var.value())
        self.options['method'] = int(config_widget.method_var.currentText()[0])
        self.options['dimension'] = config_widget.dimension_var.currentText()



        #log = logging.getLogger("calibre_plugins.pdf_to_cbz")
        log.info(f"pdfcbz: Paramètres sauvegardés → {self.options}")
