# This is a generated file! Please edit source .ksy file and use kaitai-struct-compiler to rebuild
# type: ignore

import kaitaistruct
from kaitaistruct import KaitaiStruct, KaitaiStream, BytesIO
from enum import IntEnum


if getattr(kaitaistruct, 'API_VERSION', (0, 9)) < (0, 11):
    raise Exception("Incompatible Kaitai Struct Python API: 0.11 or later is required, but you have %s" % (kaitaistruct.__version__))

class PocketbookSwupdate(KaitaiStruct):
    """PocketBook update format
    A header of 0x400 bytes containing a partition table,
    and then an array of partitions
    (c) Synacktiv 2018
    """

    class PartTypeEnum(IntEnum):
        empty = 0
        elf_megadog_img = 64
        bmp_image = 66
        dragon_tar = 84
        a_img = 97
        updatefs_cramfs = 99
        ebrmain_img = 101
        kernel_img = 107
        test_null = 110
        rootfs_img = 114
        swupdate_tar_gz = 115
        uboot_loader = 117
        uboot_loader_too = 118
    def __init__(self, _io, _parent=None, _root=None):
        super(PocketbookSwupdate, self).__init__(_io)
        self._parent = _parent
        self._root = _root or self
        self._read()

    def _read(self):
        self._raw_header = self._io.read_bytes(1024)
        _io__raw_header = KaitaiStream(BytesIO(self._raw_header))
        self.header = PocketbookSwupdate.Header(_io__raw_header, self, self._root)
        self.sections = []
        for i in range(12):
            self.sections.append(PocketbookSwupdate.Section(self._io, self, self._root))



    def _fetch_instances(self):
        pass
        self.header._fetch_instances()
        for i in range(len(self.sections)):
            pass
            self.sections[i]._fetch_instances()


    class Header(KaitaiStruct):
        def __init__(self, _io, _parent=None, _root=None):
            super(PocketbookSwupdate.Header, self).__init__(_io)
            self._parent = _parent
            self._root = _root
            self._read()

        def _read(self):
            self.magic = self._io.read_bytes(16)
            if not self.magic == b"\x50\x6F\x63\x6B\x65\x74\x42\x6F\x6F\x6B\x55\x70\x64\x61\x74\x65":
                raise kaitaistruct.ValidationNotEqualError(b"\x50\x6F\x63\x6B\x65\x74\x42\x6F\x6F\x6B\x55\x70\x64\x61\x74\x65", self.magic, self._io, u"/types/header/seq/0")
            self.model = (KaitaiStream.bytes_terminate(self._io.read_bytes(20), 0, False)).decode(u"ASCII")
            self.revision = (KaitaiStream.bytes_terminate(self._io.read_bytes(12), 0, False)).decode(u"ASCII")
            self.md5_sum = self._io.read_bytes(16)
            self.signature = self._io.read_bytes(128)
            self.unknown_buffer = self._io.read_bytes(64)
            self.fw_partitions = []
            i = 0
            while True:
                _ = PocketbookSwupdate.PartHeader(self._io, self, self._root)
                self.fw_partitions.append(_)
                if int(_.part_type) == 0:
                    break
                i += 1


        def _fetch_instances(self):
            pass
            for i in range(len(self.fw_partitions)):
                pass
                self.fw_partitions[i]._fetch_instances()



    class PartHeader(KaitaiStruct):
        def __init__(self, _io, _parent=None, _root=None):
            super(PocketbookSwupdate.PartHeader, self).__init__(_io)
            self._parent = _parent
            self._root = _root
            self._read()

        def _read(self):
            self.part_type = KaitaiStream.resolve_enum(PocketbookSwupdate.PartTypeEnum, self._io.read_u4le())
            self.unused = self._io.read_u4le()
            self.offset = self._io.read_u4le()
            self.size = self._io.read_u4le()


        def _fetch_instances(self):
            pass


    class Section(KaitaiStruct):
        def __init__(self, _io, _parent=None, _root=None):
            super(PocketbookSwupdate.Section, self).__init__(_io)
            self._parent = _parent
            self._root = _root
            self._read()

        def _read(self):
            self.data = self._io.read_bytes(4096)


        def _fetch_instances(self):
            pass



