from qt.core import (Qt, QWidget, QVBoxLayout, QLabel, QComboBox,
                     QSpinBox, QSlider, QPushButton, QHBoxLayout)
from calibre.utils.logging import default_log as log


# ───────────── Interface de configuration ─────────────
class ConfigWidget(QWidget):
    def __init__(self, options):
        super().__init__()
        self.options = options or {}
        log.info("[PDFtoCBZ] Initialisation ConfigWidget")

        layout = QVBoxLayout(self)

        # Format
        layout.addWidget(QLabel("Format :"))
        self.format_var = QComboBox()
        self.format_var.addItems(["png", "jpg"])
        self.format_var.setCurrentText(str(self.options.get("output_format", "jpg")))
        layout.addWidget(self.format_var)

        # DPI
        #layout.addWidget(QLabel("Resolution (DPI) (in future version):"))
        self.dpi_var = QSpinBox()
        self.dpi_var.setRange(50, 600)
        self.dpi_var.setValue(int(self.options.get("dpi", 200)))
        #layout.addWidget(self.dpi_var)

        # Compression
        #layout.addWidget(QLabel("Compression (0=quality, 100=max compression) (in test):"))
        self.comp_var = QSlider()
        self.comp_var.setOrientation(Qt.Horizontal)
        self.comp_var.setRange(0, 100)
        self.comp_var.setValue(int(self.options.get("compression", 95)))
        #layout.addWidget(self.comp_var)


        # methode de conversion
        layout.addWidget(QLabel("méthode :"))
        self.method_var = QComboBox()
        self.method_var.addItems(["1-in order", "2-in Parallel", "3-in task"])
        self.method_var.setCurrentText(str(self.options.get("method", "1-in order")))
        layout.addWidget(self.method_var)
        self.setLayout(layout)
        log.info("[PDFtoCBZ] ConfigWidget prêt")
