#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Pr.BarnArt based on the Barnes work by Grant Drake'
__docformat__ = 'restructuredtext en'

import time
import urllib
import string

try:
    # For Python 3.0 and later
    from urllib.request import Request, urlopen
except ImportError:
    # Fall back to Python 2's urllib2
    from urllib2 import Request,urlopen

try:
    from urllib.parse import quote,urlencode
except ImportError:
    from urllib import quote,urlencode
    
try:
    from queue import Queue, Empty
except ImportError:
    from Queue import Queue, Empty  
from lxml import html
from lxml.html import fromstring, tostring
from xml.etree import ElementTree

from calibre import as_unicode
from calibre.ebooks.metadata import check_isbn
from calibre.ebooks.metadata.sources.base import Source
from calibre.utils.icu import lower
from calibre.utils.cleantext import clean_ascii_chars
from calibre.utils.localization import get_udc
#from calibre import ipython
import sys
try:
    from PyQt6 import  QtGui
except ImportError:
    from PyQt5 import QtGui
try:
    from PyQt6.QtCore import *
except ImportError:
    from PyQt5.QtCore import *
    
try:
    from PyQt6.QtWidgets import QDialog
except ImportError:
    from PyQt5.QtWidgets import QDialog
try:
    from PyQt6.Qt import QLabel,QListWidget
except ImportError:
    from PyQt5.Qt import QLabel,QListWidget
#from PyQt4.QtGui import *





class MismatchDialog(QDialog):

    def __init__(self,listdata,key,title,authors):
        super(MismatchDialog, self).__init__()
        #pdb.set_trace()
        self.data= list()
        self.data=listdata
        self.title=title
        self.author=authors
        self.initUI()


    def initUI(self):
        label=QLabel("Er is geen exacte match gevonden voor")
        label2=QLabel('zoektitel: ' + self.title)
        label3=QLabel('schrijver: ' + self.author)
        label4=QLabel('Onderstaande titels zijn afgewezen')
        label5=QLabel('Selecteer eventueel een correcte titel ')
        label6=QLabel('of anders "Geen correcte titel" (= default)')
        self.lw = QListWidget()
        self.lw.addItem('"Geen correcte titel"')
        for item in self.data:
            self.lw.addItem(item)
        self.lw.setCurrentRow(0)
        aantal=self.lw.count()
        #self.connect(self.lw, SIGNAL("itemSelectionChanged()"), self.on_select)

        self.lw.doubleClicked.connect(self.Sluiten)
        okButton = QtGui.QPushButton("OK")
        cancelButton = QtGui.QPushButton("Cancel")
        okButton.clicked.connect(self.Sluiten)
        cancelButton.clicked.connect(self.Cancel)

        hbox = QtGui.QHBoxLayout()
        hbox.addStretch(1)
        hbox.addWidget(cancelButton)
        hbox.addWidget(okButton)

        layout=QtGui.QVBoxLayout();
        layout.addStretch(1)
        layout.addWidget(label)
        layout.addWidget(label2)
        layout.addWidget(label3)
        layout.addWidget(label4)
        layout.addWidget(label5)
        layout.addWidget(label6)
        layout.addWidget(self.lw)
        layout.addLayout(hbox)
        self.setLayout(layout)

        if aantal>10:
            aantal=10
        self.setGeometry(300,300,275,120+aantal*20)
        self.setWindowTitle('Geen exacte match')
        okButton.setFocus()


    def Sluiten(self):
        self.done(self.lw.currentRow())

    def Cancel(self):
        self.lw.setCurrentRow(0)
        self.Sluiten()

    def closeEvent(self, event):
        key=self.lw.currentRow();
        self.done(self.lw.currentRow())

    def getValue(self):
        return self.lw.currentRow();


class BOL_NL(Source):


    name                    = 'BOL_NL'
    description             = _('Downloads metadata en covers van BOL.com or from Literatuurplein.nl')
    author                  = 'Pr. BarnArt'
    version                 = (5, 2, 9)
    minimum_calibre_version = (0, 8, 5)

    capabilities = frozenset(['identify', 'cover'])
    touched_fields = frozenset(['title', 'authors', 'identifier:isbn', 'rating', 'comments', 'publisher', 'pubdate','languages', 'tags'])
    has_html_comments = True
    supports_gzip_transfer_encoding = True
    cached_cover_url_is_reliable = True


    mismatch_title = list()
    mismatch_url = list()

    BASE_URL0 = 'https://www.bol.com'
    BASE_URL = 'https://www.bol.com/nl/s/boeken/zoekresultaten/Ntt/'
    BASE_ISBN= '/Nty/1/search/true/searchType/adv/section/books/N/8293/Ntk/isbncode/index.html?_requestid=116710'
    BASE_URL_1 = '/Ntk/nl_books_all/Nty/1/N/8299+8293/Ne/8299+8293'
    BASE_URL_LAST = '/search/true/searchType/qck/index.html?_requestid=17572'
    BASE_ISBN0= 'https://www.bol.com/nl/s/boeken/zoekresultaten/Ntt/'
    BASE_ISBN1='/Ntk/isbncode/Nty/1/N/8299+8293/Ne/8299+8293/search/true/searchType/qck/toonAlle/true/index.html?_requestid=136981'
    NEW_BASE_URL0 = 'https://www.bol.com/nl/nl/s/?searchtext='
    NEW_BASE_URL1 = '&searchContext=media_all&appliedSearchContextId=&suggestFragment=&adjustedSection=&originalSection=&originalSearchContext=&section=main&N=0&defaultSearchContext=media_all'
    NEW_BASE_URL2='&bltgh=6f4031a5-0202-4553-a6c7-f1cd1cd9e1b5.g.i.QueryContextHook'
    EXTENSION_URL='/?bltgh=db90ce03-cfe0-46af-97d7-c50df0ab7105.ProductList_Middle.0.ProductImage'
    
    def config_widget(self):
        '''
        Overriding the default configuration screen for our own custom configuration
        '''
        from calibre_plugins.BOL_NL.config import ConfigWidget
        return ConfigWidget(self)

    def get_book_url(self, identifiers):
        bol_nl_id = identifiers.get('bol_nl', None)
        if bol_nl_id:
            return ('bol_nl', bol_nl_id,
                  '%s%s%s'%(BOL_NL.BASE_URL, bol_nl_id,BOL_NL.BASE_URL_LAST))


    def create_query(self, log, title=None, authors=None, identifiers={}):

        isbn = check_isbn(identifiers.get('isbn', None))
        #print('isbn:',isbn)
        q = ''
        if isbn is not None:
            
            #urltxt='https://www.bol.com/nl/rnwy/search.html' 
            #urltxt ='https://www.bol.com/nl/s/?searchtext=' + isbn
            urltxt='https://www.bol.com/nl/s/?searchtext='+isbn+ BOL_NL.NEW_BASE_URL2
            d = dict(searchtext=isbn,searchContext="books_all",appliedSearchContextId="",suggestFragment="",adjustedSection="",originalSection="",originalSearchContext="",section="main",N=0,defaultSearchContext="media_all")
            #d = dict(searchtext=isbn,searchContext="media_all",section="main",N=0,defaultSearchContext="media_all")
            #txtvalues=isbn
            
            #data = urlencode(d)
            #urltxt+=data
            
            #data=data.encode('utf-8')
           
            print('urltx:',urltxt)
            #print('data:',data)
            return(urltxt)
            req =  Request(urltxt, data)
            response = urlopen(req)
            #print("url2",response)
            url2=response.geturl()
            #print("url2",url2)
            return(url2)


        if title:
            # BOL  maybe doesn't cope very well with non ascii names so convert
            title = get_udc().decode(title)
            title_tokens = list(self.get_title_tokens(title,
                                strip_joiners=False, strip_subtitle=True))
            if title_tokens:
                tokens = [quote(t.encode('utf-8') if isinstance(t, str) else t) for t in title_tokens]
                q='+'.join(tokens)


        if authors:
            # BOL  maybe doesn't cope very well with non ascii names so convert
            authors = [get_udc().decode(a) for a in authors]
            author_tokens = self.get_author_tokens(authors,
                    only_first_author=True)
            if author_tokens:
                tokens = [quote(t.encode('utf-8') if isinstance(t, str) else t) for t in author_tokens]
                q+='+'+'+'.join(tokens)
                #import calibre_plugins.BOL_NL.config as cfg
                #ebook = cfg.plugin_prefs[cfg.STORE_NAME].get(cfg.KEY_EBOOK,cfg.DEFAULT_STORE_VALUES[cfg.KEY_EBOOK])
                #if ebook:
                    #q+='+ebook'

        if not q:
            return None
        return '%s%s%s'%(BOL_NL.NEW_BASE_URL0, q,BOL_NL.NEW_BASE_URL2)

    def get_cached_cover_url(self, identifiers):
        url = None
        bol_nl_id = identifiers.get('bol_nl', None)
        if bol_nl_id is  None:
            isbn = identifiers.get('isbn', None)

            if isbn is not None:
               bol_nl_id = self.cached_isbn_to_identifier(isbn)
        if bol_nl_id is not None:
            url = self.cached_identifier_to_cover_url(bol_nl_id)
        return url



    def cached_identifier_to_cover_url(self, id_):
        with self.cache_lock:
            url = self._get_cached_identifier_to_cover_url(id_)
            if not url:
                # Try for a "small" image in the cache
                url = self._get_cached_identifier_to_cover_url('small/'+id_)
            return url

    def _get_cached_identifier_to_cover_url(self, id_):
        # This must only be called once we have the cache lock
        url = self._identifier_to_cover_url_cache.get(id_, None)
        if not url:
            # We could not get a url for this particular B&N id
            # However we might have one for a different isbn for this book
            # Barnes & Noble are not very consistent with their covers and
            # it could be that the particular ISBN we chose does not have
            # a large image but another ISBN we retrieved does.
            key_prefix = id_.rpartition('/')[0]
            for key in self._identifier_to_cover_url_cache.keys():
                if key.startswith('key_prefix'):
                    return self._identifier_to_cover_url_cache[key]
        return url

    def identify(self, log, result_queue, abort, title=None, authors=None,
            identifiers={}, timeout=30):
        '''
        Note this method will retry without identifiers automatically if no
        match is found with identifiers.
        '''
        matches = []
        #need to read the ratings of an indexpage, i cannot trace them on the productpage
        #use ratings for the selected matches, so the order of rating is equal to matches
        ratings = []
        # If we have a BOL id then we do not need to fire a "search"
        # at BOL.com. Instead we will go straight to the URL for that book.

        bol_nl_id = identifiers.get('bol_nl', None)
        isbn = check_isbn(identifiers.get('isbn', None))
        br = self.browser

        if bol_nl_id:
            matches.append('%s%s%s%s'%(BOL_NL.BASE_URL, bol_nl_id,BOL_NL.BASE_URL_1,BOL_NL.BASE_URL_LAST))
        else:
            query = self.create_query(log, title=title, authors=authors,
                    identifiers=identifiers)
            if query is None:
                log.error('Insufficient metadata to construct query')
                return

            isbn_match_failed = False
            log.info('Querying: %s'%query)

            response = br.open_novisit(query, timeout=timeout)
            if isbn:
                try:
                    raw = response.read().strip()
                    raw = raw.decode('utf-8', errors='replace')
                    if not raw:
                        log.error('Failed to get raw result for query: %r'%query)
                        return
                    root = fromstring(clean_ascii_chars(raw))
                    #with open("output1.xml", "w", encoding="utf-8") as file:
                    #        for a in root:
                    #            test_resultaat = ElementTree.tostring(a, encoding="unicode")
                    #            file.write(test_resultaat + "\n")
                    url_node=root.xpath('//h1[@class="bol_header"]')
                    if url_node:
                        for a in url_node:
                            test_resultaat=ElementTree.tostring(a).decode()
                            #print('test resultaat:',test_resultaat)
                    url_node=root.xpath('//a[contains(@class,"product-title px_list_page_product_click")]/@href')
                    #<a class="product-title px_list_page_product_click h-boxedright--xs" href="/nl/p/stille-getuigen/9200000009427933/" data-test="product-title" data-no-translate="true" data-bltgh="mCSJsqbzcUToUJ9w7DZNBw.1_4.5.ProductTitle" data-list-page-product-click-location="title">Stille getuigen</a>
                    #print('url_node isbn:',url_node)
                    #a = root.xpath('//div[@class="flex w-full"]') #/a[@class="w-full"]')
                    #a = root.xpath('//a[@class="w-full"]')
                    #a_node = root.xpath('//a[@class="w-full"]')
                    a_node = root.xpath('//div[@class="flex w-full"]/a[contains(@class, "w-full")]')
                    #print('a-node',a_node)
                    if a_node:
                        a = a_node[0]
                        #print("Raw element:", html.tostring(a, pretty_print=True).decode())
                        href = a.get('href')
                        #bltgh = a.get('data-bltgh')
                        
                        if href:
                            isbn_url = BOL_NL.BASE_URL0 + f"{href}" + BOL_NL.EXTENSION_URL
                            
                            print('isbn_url:',isbn_url)
                        else:
                            print("Missing href .")
                   
                                            
                    else:
                        print("No <a class='w-full'> found.")
                        

                        a_node = root.xpath('//div [@class="product-item__content"]/div/div[@class="product-title--inline "]/wsp-analytics-tracking-event/a') #//div [@class="product-title--inline"]//wsp-analytics-tracking-event/a'
                        #print('a-node-alt',a_node) 
                        if a_node:
                            a = a_node[0]
                            #print("Raw element_alt:", html.tostring(a, pretty_print=True).decode())
                            href = a.get('href')
                        #bltgh = a.get('data-bltgh')
                        
                        if "href" in locals():
                            if href:
                                isbn_url = BOL_NL.BASE_URL0 + f"{href}" + BOL_NL.EXTENSION_URL
                            
                                print('isbn_url_alt:',isbn_url)
                            else:
                                print("Missing href .")
                        
                        
                       
                                isbn_url=query
                                print('isbn_url_direct:',isbn_url)
                        
                    if "isbn_url"in locals():    
                        matches.append(isbn_url)
                        rating='0'
                        ratings.append(rating)
                        isbn_match_failed = False
                except:
                    msg = 'Failed to parse BOL.com page for query: %r'%query
                    log.exception(msg)
                    return msg

            # For successful ISBN based searches we have already done everything we need to
            # So anything from this point below is for title/author based searches.
            if not isbn or isbn_match_failed:
                try:
                    raw = response.read().strip()
                    raw = raw.decode('utf-8', errors='replace')
                    if not raw:
                        log.error('Failed to get raw result for query: %r'%query)
                        return
                    '''
                    f = open("datafile.xml", "w")
                    try:
                        f.write(raw.rstrip('\n') )
                    finally:
                        f.close()
                    '''

                    root = fromstring(clean_ascii_chars(raw))
                except:
                    msg = 'Failed to parse BOL.com page for query: %r'%query
                    log.exception(msg)
                    return msg
                # Now grab the matches from the search results, provided the
                # title and authors appear to be for the same book
                self._parse_search_results(log, title, authors, root, matches,ratings,timeout)

        if abort.is_set():
            return
        import calibre_plugins.BOL_NL.config as cfg
        reject = cfg.plugin_prefs[cfg.STORE_NAME].get(cfg.KEY_REJECTED,cfg.DEFAULT_STORE_VALUES[cfg.KEY_REJECTED])

        schrijver=''
        if authors:
            for s in authors:
                schrijver=s
                break

        '''
        if not matches and reject:
            #---------
            ##app = QtGui.QGuiApplication(sys.argv)
            app = QtWidget.setScreen()
            key=0
            key2=0
            mis_dialog= MismatchDialog(self.mismatch_title,key,title,schrijver)
            key2=mis_dialog.exec_()  # key2 another way to retrieve de selectedindex
            key= mis_dialog.getValue()

            if key>0:
                key-=1  # minus 1, because the first item is "Geen" and not in the mismatch list
                result=self.mismatch_url[key]
                result_url = BOL_NL.BASE_URL0 + result.xpath('@href')[0]
                #result_url = result.xpath('@href')[0]
                matches.append( result_url)
                ratings.append('0')
                #---------
            else:
                
                if identifiers and title and authors:
                    log.info('No matches found with identifiers, retrying using only'
                            ' title and authors')
                    return self.identify(log, result_queue, abort, title=title,
                            authors=authors, timeout=timeout)
                
                log.error('No matches found with query: %r'%query)
                return
        '''

        from calibre_plugins.BOL_NL.worker import Worker
        #need to mix url and ratings for the worker class
        combos= zip(matches,ratings)


        workers = [Worker(combo, result_queue, br, log, i, self) for  i,combo in
                enumerate(combos)]
        for w in workers:
            w.start()
            # Don't send all requests at the same time
            time.sleep(0.1)

        while not abort.is_set():
            a_worker_is_alive = False
            for w in workers:
                w.join(0.2)
                if abort.is_set():
                    break
                if w.is_alive():
                    a_worker_is_alive = True
            if not a_worker_is_alive:
                break

        return None

    def _parse_search_results(self, log, orig_title, orig_authors, root, matches, ratings, timeout):
        srt=0
        results = root.xpath('//a[@class="product_name"]')
        print('results1:',results)
        if not results:
            #/ul/li/div [@class="product-item_content"]
            results = root.xpath('//div [@class="results-area"]/ul/li/div [@class="product-item__content"]/div/div/a [@class="product-title px_list_page_product_click"]')
            #print('results2:',results)
        if not results:
            results = root.xpath('//div [@class="product-item__info"]/div/a [@class="product-title"]')
            ##print('results3:',results)
        if not results:
            results = root.xpath('//div [@class="product-item__info hit_area"]/div/a [@class="product-title"]')
            ##print('results4:',results)
        if not results:
            results = root.xpath('//div [@class="product-item__content"]/div/div/wsp-analytics-tracking-event/a [@data-test="product-title"]')
            #print('results5:',results)
            srt=6
        if not results:
            print ('start7')
            #results=root.xpath('//div[@data-bltgh="cb91d126-d6df-48c8-95ca-ba71d3774e63.ProductList_Middle.0.ProductTitle"]')
            results=root.xpath('//main  [@id="mainContent"]/div/div/div[@class="flex"]/div/div/div/div/div/a ')
            print('result7:', results)
            srt=7
        if not results:
            #print('results5:',results)
            srt=8
        print('srt-x:',srt)
        if not results:

            return

        def ismatch(title):
            #only if the title exact matches
            match = False
            if isinstance(title, bytes):
                title = title.decode("utf-8")

            print( "1titel", title.lower().translate(str.maketrans("", "", string.punctuation + " ")))

            #print('titel',lower(title).translate(str.maketrans('', '', string.punctuation + ' ')))
            print('org_titel',orig_title.lower().translate(str.maketrans('', '', string.punctuation + ' ')))
            if title.lower()==orig_title.lower():
                match= True
            if match==False:
                if orig_title[:3].lower()=='de ':
                    if title.lower()==orig_title[3:].lower():
                        
                        match=True
                        print("de match",match)
                if orig_title[:4].lower()=='het ':
                    if title.lower()==orig_title[4:].lower():
                        match=True
                        print("het match",match)
                if orig_title[:4].lower()=='een ':
                    if title.lower()==orig_title[4:].lower():
                        match=True
                        print("een match",match)
                if match== False:
                    
                    if title.lower().translate(str.maketrans("", "", string.punctuation + " "))==orig_title.lower().translate(str.maketrans("", "", string.punctuation + " ")):
                        match=True
                        print("punct match",match)
            print(match)
            return match
        import calibre_plugins.BOL_NL.config as cfg
        max_results = cfg.plugin_prefs[cfg.STORE_NAME][cfg.KEY_MAX_DOWNLOADS]
        ebook  =cfg.plugin_prefs[cfg.STORE_NAME][cfg.KEY_EBOOK]

        print('results1totaal',results)
        for result in results:
            print(result)
            if srt==5:
                title_result=result.xpath('//span[@class="truncate"]')
                ##print('title_result:',title_result)
                title=title_result[0].text_content().replace('\n',' ').strip()
                ##print('title:',title)
            else:
                title = result.text_content().replace('\n',' ').strip()
                print('title:',title)
                if title=="" and srt==7:
                   alt_text = result.xpath('//img/@alt')[0]
                   print('alt_text:', alt_text)
                   title=alt_text

            while '  ' in title:
                title = title.replace('  ',' ')
            # Strip off any series information from the title
            if '(' in title:
                title = title.rpartition('(')[0].strip()
                title_tokens = list(self.get_title_tokens(orig_title))
            
            if not ismatch(title):
                pos=title.find(' - ')
                print('streepje gevonden', pos)
                if pos>0:
                    title=title.rpartition(' - ')[2].strip()
                    print('title without serie?:', title)
            if not ismatch(title):
                log.error('Rejecting as not close enough match: %s '%(title))
                
                self.mismatch_title.append(title)

                self.mismatch_url.append(result)

            else:
                # Validate that the cat  is  not one we are not interested in
                valid_cat = True
                if ebook:
                    valid_cat=False
                #[@class="product-small-specs"]/li/span
                catnode= result.xpath('../../ul [@class="product-small-specs"]/li/span')
                print('catnode1',catnode)
                if not catnode:
                    catnode = result.xpath('../span [@class="labels label_secondary"]')
                    print('catnode2',catnode)
                if not catnode:
                    catnode = result.xpath('../ul [@class="product-small-specs"]/li/span')
                    print('catnode3',catnode)
                txt=''
                
                if catnode: #print('catnode:',catnode)
                    for cat in catnode:
                        if  catnode:
                            txt= cat.text_content().strip().lower()
                        if( ebook and txt=='ebook'):
                            valid_cat = True
                            break
                        if(txt=='audio boek'):
                            valid_cat = False
                        if(txt=='audio + books'):
                            valid_cat = False
                        if(txt=='tweedehands'):
                            valid_cat = False
                else:
                    print('result:',result.text_content())
                    catnode = result.xpath('following::span[@class="labels label_product-type"]/text()')



                    #catnode = result.xpath('following::span[@class="labels label_product-type"])/text()')
                    print('catnode4',catnode)
                    if catnode:
                        txt= catnode[0].lower()
                        print('txt',txt)
                        if( ebook and txt=='ebook'):
                            valid_cat = True
                            print('found ebook')
                            print('valid_cat:',valid_cat)
                        
                        
                   

                rating='0'

                print('valid_cat2:',valid_cat)
                rtxt='../../div/div [@data-test="rating-stars"]/@title'
                rating_node=result.xpath(rtxt)
                if rating_node:
                    ratingtxt=''.join(rating_node)
                    pos= ratingtxt.find(":")
                    if pos:
                        rating=ratingtxt[pos+2:pos+3]
                        #print('rating:',rating)
                if not valid_cat:
                    self.mismatch_title.append(title)

                    self.mismatch_url.append(result)
                if valid_cat:
                    result_url = BOL_NL.BASE_URL0 + result.xpath('@href')[0]
                    matches.append( result_url)
                    ratings.append(rating)
                    if len(matches) >= max_results:
                        break

    def download_cover(self, log, result_queue, abort,
            title=None, authors=None, identifiers={}, timeout=30):
        cached_url = self.get_cached_cover_url(identifiers)
        print('cached_url:',cached_url)
        if cached_url is None:
            log.info('No cached cover found, running identify')
            rq = Queue()
            self.identify(log, rq, abort, title=title, authors=authors,
                    identifiers=identifiers)
            if abort.is_set():
                return
            results = []
            while True:
                try:
                    results.append(rq.get_nowait())
                except Empty:
                    break
            results.sort(key=self.identify_results_keygen(
                title=title, authors=authors, identifiers=identifiers))
            for mi in results:
                cached_url = self.get_cached_cover_url(mi.identifiers)
                if cached_url is not None:
                    break
        if cached_url is None:
            log.info('No cover found')
            return

        if abort.is_set():
            return
        br = self.browser
        log('Downloading cover from:', cached_url)
        check = False
        try:
            cdata = br.open_novisit(cached_url, timeout=timeout).read()
            result_queue.put((self, cdata))
        except:
            log.exception('Failed to download cover from:', cached_url)
            check= True
        if not check:
            return
        try:
            cached_url='https:' + cached_url
            cdata = br.open_novisit(cached_url, timeout=timeout).read()
            result_queue.put((self, cdata))
        except:
            log.exception('Failed to download cover from:', cached_url)




if __name__ == '__main__': # tests
    # To run these test use:
    # calibre-debug -e __init__.py
    from calibre.ebooks.metadata.sources.test import (test_identify_plugin,
            title_test, authors_test)
    test_identify_plugin(BOL_NL.name,
        [
              (# A book with an ISBN
                {'identifiers':{'isbn': 'isbn:9789048556748'},
                'title':'De griekse dochter', 'authors':['Soraya Lane']},
                [title_test('Het meisje aan de andere kant van de muur',
                    exact=True), authors_test(['Joshua M. Greene']),
                ]

             ),
            
             (# A book with an ISBN
                {
                'title':'Miami', 'authors':['Kiki van Dijk']},
                [title_test('Het meisje aan de andere kant van de muur',
                    exact=True), authors_test(['Joshua M. Greene']),
                ]

             ),
              (# A book with an ISBN
                {'identifiers':{'isbn': 'isbn:9789180873307'},
                'title':'Miami', 'authors':['Kiki van Dijk']},
                [title_test('Het meisje aan de andere kant van de muur',
                    exact=True), authors_test(['Joshua M. Greene']),
                ]

             ),
             
             
             
             
             (# A book without an ISBN
                {'title':"Zwemmen in het donker", 'authors':['Tomasz Jedrowski']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]
             ),
             (# A book without an ISBN
                {'title':"Bevrijdingsvuur", 'authors':['Noud Bles']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]
             ),
            (# A book without an ISBN
                {'title':"Prooi", 'authors':['Ayaan Hirsi Ali']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]
             ),
             (# A book with no ISBN specified
                {'title':"Complot in Congo", 'authors':['Jeanette Windle']},
                [title_test("Complot in Congo", exact=True),
                 authors_test(['Jeanette Windle'])
                ]

            ),
             
            (# A book without an ISBN
                {'title':"Mahjong brigade", 'authors':['John Trenhaile']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]

            ),
            
           
           
            
            
            (# A book without an ISBN
                {'title':"De laatste Martiaan", 'authors':['Ray Bradbury']},
                [title_test('Nachtelijk vuur',
                    exact=True), authors_test(['Sylvia Day']),
                ]

            ),


            


            ( # A book with no ISBN specified
                {'title':"De nedergrim", 'authors':['Mathew Jobin']},
                [title_test("De eetclub", exact=True),
                 authors_test(['Saskia Noort'])
                ]

            ),

            (# A book with no ISBN specified
                {'title':"De verdenking", 'authors':['Michael Robotham']},
                [title_test("De eetclub", exact=True),
                 authors_test(['Saskia Noort'])
                ]

            ),

            (# A book with an ISBN
                {'identifiers':{'isbn': 'isbn:9021401975'},
                    'title':'Stille Getuige', 'authors':['Maarten Brand']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]

            ),

            ( # A book with no ISBN specified
                {'title':"De eetclub", 'authors':['Saskia Noort']},
                [title_test("De eetclub", exact=True),
                 authors_test(['Saskia Noort'])
                ]

            ),
            (# A book with an ISBN
                {'identifiers':{'isbn': 'isbn:99033608294'},
                    'title':'Stille Getuige', 'authors':['Maarten Brand']},
                [title_test('Stille Getuige',
                    exact=True), authors_test(['Maarten Brand']),
                ]

            ),



            (# A book with noISBN
                {'title':'de nedergrim / boek 1', 'authors':['Matthew Jobin']},
                [title_test('de nedergrim / boek 1', exact=True),
                 authors_test(['Matthew Jobin'])
                ]
            ),
            (# A book with no ISBN
                {'title':'Powerfood', 'authors':['Rens Kroes']},
                [title_test('Powerfood', exact=True),
                 authors_test(['Rens Kroes'])
                ]
            ),

            ( # A book with an ISBN
                {'identifiers':{'isbn': 'isbn:9041419780'},
                    'title':'De eetclub', 'authors':['Saskia Noort']},
                [title_test('De eetclub',
                    exact=True), authors_test(['Saskia Noort']),
                    ]

            ),

            ( # A book with no ISBN specified
                {'title':"Time out", 'authors':['Judith Visser']},
                [title_test("Time out",
                    exact=True), authors_test(['Judith Visser']),
                    ]

            )




        ])


