﻿# ---------------------------------------------------------
# ENV VAR DEFINITIONS
# ---------------------------------------------------------
ENV_VARIABLES = [
    {
        "name": "SIGIL_DISABLE_VERSION_META",
        "description": "Prevents Sigil from adding the metadata that identifies Sigil as the producer of the epub.",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_DISABLE_NFC_NORMALIZATION",
        "description": "Disables Unicode NFC normalization of content. WARNING: many e-readers may not be able to search accented text properly.",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_FOCUS_HIGHLIGHT_COLOR",
        "description": "CSS hex color (e.g. #FF0000) used when focus highlight rectangles are enabled.",
        "type": "string",
        "platform": "all"
    },
    {
        "name": "SIGIL_ALLOW_CODEVIEW_DROP",
        "description": "Enables drag & drop editing in CodeView. WARNING: may be unstable and cause crashes (Qt6 issue).",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_DEBUG_LOGFILE",
        "description": "Full path to a writable logfile. Sigil will write debug information here. Remember to unset after debugging to avoid disk bloat.",
        "type": "string",
        "platform": "all"
    },
    {
        "name": "SIGIL_FUNCTION_REPLACE_LOGFILE",
        "description": "Full path to a writable logfile. Sigil will write Python Function Replace messages here. Remember to unset after debugging.",
        "type": "string",
        "platform": "all"
    },
    {
        "name": "SIGIL_USE_FREETYPE_FONTENGINE",
        "description": "Windows only. Forces Sigil to use the FreeType Font Engine, useful for WOFF/WOFF2 fonts.",
        "type": "bool",
        "platform": "windows"
    },
    {
        "name": "SIGIL_PREVIEW_TIMEOUT",
        "description": "Milliseconds of idle time before Preview updates after CodeView edits. Valid range: 1000–10000.",
        "type": "int",
        "platform": "all",
        "min": 0,
        "max": 10000
    },
    {
        "name": "SIGIL_DRAG_DISTANCE_TWEAK",
        "description": "Windows only. Adjusts pixel distance before drag is detected. Valid range: -20 to 20.",
        "type": "int",
        "platform": "windows",
        "min": -20,
        "max": 20
    },
    {
        "name": "SIGIL_DISABLE_CURSOR_BLINK",
        "description": "Disables blinking cursor in CodeView and input dialogs (useful for people sensitive to flashing).",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_SKIP_UPDATE_CHECK",
        "description": "Prevents Sigil from using the network to check for newer versions (useful for Linux distros with their own builds).",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_PREFS_DIR",
        "description": "Overrides default location of Sigil Preferences folder. This variable is not read from the env-vars.txt file, but from the system.",
        "type": "special",
        "platform": "all"
    },
    {
        "name": "SIGIL_EXTRA_ROOT",
        "description": "Linux only. Specifies the location of Sigil's share/sigil folder.",
        "type": "string",
        "platform": "linux"
    },
    {
        "name": "SIGIL_DICTIONARIES",
        "description": "Linux only. Specifies where hunspell dictionaries are located.",
        "type": "string",
        "platform": "linux"
    },
    {
        "name": "SIGIL_USE_COLORSCHEME_CHANGED",
        "description": "Linux only. This tells Sigil that your system supports the QStyleHints::colorSchemeChanged signal, which detects when the theme changes between light and dark.",
        "type": "bool",
        "platform": "linux"
    },
    {
        "name": "SIGIL_FORCE_NATIVE_FILE_DIALOG",
        "description": "Forces Sigil to use the operating system's native file dialog. WARNING: may be unstable and cause crashes.",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_NO_CUSTOM_DIRECTORY_ICONS",
        "description": "Prevents searching for system-level custom icons in file dialogs, improving performance on network drives with many files.",
        "type": "bool",
        "platform": "all"
    },
    {
        "name": "SIGIL_ONLY_USE_LANGCODES",
        "description": "To easily restrict long list of language codes to user's choice. A valid list of ISO 639 lanugage codes separated by commas `,` with NO extra spaces allowed.",
        "type": "string", 
        "platform": "all"
    },
    {
        "name": "QT_QPA_PLATFORM",
        "description": "Qt6 variable. Controls the QPA platform plugin (e.g. 'xcb', 'wayland', 'windows'). See Qt6 docs.",
        "type": "string",
        "platform": "all"
    },
    {
        "name": "QTWEBENGINE_CHROMIUM_FLAGS",
        "description": "Qt6 variable. Allows passing Chromium flags to QtWebEngine. See Qt6 docs for usage.",
        "type": "string",
        "platform": "all"
    },
]
