from __future__ import (unicode_literals, division, absolute_import, print_function)

from PyQt5.Qt import (QGroupBox, QVBoxLayout, QWidget, QCheckBox)

from calibre.utils.config import JSONConfig


__license__ = "GPL v3"
__copyright__ = "2017-2025, John Howell <jhowell@acm.org>"

# Individual Setting names
EnableUpdatingAllMetadata = "EnableUpdatingAllMetadata"

# Set location where all preferences for this plugin will be stored
plugin_config = JSONConfig("plugins/KFX Output")

# Default values
plugin_config.defaults[EnableUpdatingAllMetadata] = False


class ConfigWidget(QWidget):
    def __init__(self):
        QWidget.__init__(self)

        layout = QVBoxLayout(self)
        layout.addWidget(self.options_group_box())
        layout.addStretch()
        self.setLayout(layout)

    def options_group_box(self):
        group_box = QGroupBox("Options:", self)
        layout = QVBoxLayout()
        group_box.setLayout(layout)

        self.EnableUpdatingAllMetadata = QCheckBox("Enable updating of all KFX metadata")
        self.EnableUpdatingAllMetadata.setToolTip(
            "By default the ASIN, CDEType, and Language fields are not updated by this plugin\n"
            "after a KFX file is created since changing those can cause problems with an exported book.\n"
            "Check this option to enable Set KFX Metadata to alter these fields.")
        layout.addWidget(self.EnableUpdatingAllMetadata)
        self.EnableUpdatingAllMetadata.setChecked(plugin_config[EnableUpdatingAllMetadata])

        layout.addStretch()
        return group_box

    def save_settings(self):
        # Called by calibre when the configuration dialog has been accepted
        plugin_config[EnableUpdatingAllMetadata] = self.EnableUpdatingAllMetadata.isChecked()


def config_enable_updating_all_metadata():
    return plugin_config[EnableUpdatingAllMetadata]
