# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import)
from calibre.ebooks import BOOK_EXTENSIONS
from calibre.gui2.dialogs.select_formats import SelectFormats, Formats
try:
    from calibre.gui2 import NONE
except:
    pass

__license__ = 'GPL 3'
__copyright__ = '2014, Saulius P. <saulius@kofmarai.net>'
__docformat__ = 'restructuredtext en'

try:
    from PyQt5.Qt import QModelIndex, QItemSelectionModel, QDialog, Qt, QVariant, QVBoxLayout, QLabel, QListView, QDialogButtonBox, QSize
except ImportError:
    from PyQt4.Qt import QModelIndex, QItemSelectionModel, QDialog, Qt, QVariant, QVBoxLayout, QLabel, QListView, QDialogButtonBox, QSize
#from calibre_plugins.savetoformat.gui.config import prefs 
from calibre.gui2.dialogs.select_formats import Formats

class SelectHyphenateFormats(QDialog):

    def __init__(self, fmt_count, msg, single=False, parent=None, exclude=False):
        QDialog.__init__(self, parent)
        self._l = QVBoxLayout(self)
        self.single_fmt = single
        self.setLayout(self._l)
        self.setWindowTitle(_('Choose formats to hyphenate'))
        self._m = QLabel(msg)
        self._m.setWordWrap(True)
        self._l.addWidget(self._m)
        self.formats = Formats(fmt_count)
        self.fview = QListView(self)
        self.fview.doubleClicked.connect(self.double_clicked,
                type=Qt.QueuedConnection)
        if exclude:
            self.fview.setStyleSheet('''
                    QListView { background-color: #FAE7B5}
                    ''')
        self._l.addWidget(self.fview)
        self.fview.setModel(self.formats)
        self.fview.setSelectionMode(self.fview.SingleSelection if single else
                self.fview.MultiSelection)
        self.bbox = \
        QDialogButtonBox(QDialogButtonBox.Ok|QDialogButtonBox.Cancel,
                Qt.Horizontal, self)
        self._l.addWidget(self.bbox)
        self.bbox.accepted.connect(self.accept)
        self.bbox.rejected.connect(self.reject)
        self.fview.setIconSize(QSize(48, 48))
        self.fview.setSpacing(2)

        self.resize(350, 500)
        self.selected_formats = []

    def accept(self, *args):
        for idx in self.fview.selectedIndexes():
            self.selected_formats.append(self.formats.fmt(idx))
        QDialog.accept(self, *args)

    def double_clicked(self, index):
        if self.single_fmt:
            self.accept()

