# -*- coding: utf-8 -*-

from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__ = 'GPL 3'
__copyright__ = '2019, Saulius P. <saulius@kofmarai.net>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

SUPPORTED_FORMATS = ['epub', 'azw3']

class ActionHyphenateThis(InterfaceActionBase):

    name = 'Hyphenate This!'
    description = _('Hyphenate books for readers supporting soft hyphens.')
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Saulius P.'
    version = (0, 1, 3)
    minimum_calibre_version = (0, 9, 27)
    
    actual_plugin = 'calibre_plugins.hyphenatethis.hyphenatethisaction:HyphenateThisAction'
    
    def is_customizable(self):
        '''
        This method must return True to enable customization via
        Preferences->Plugins
        '''
        return True
    
    def config_widget(self):
        from calibre_plugins.hyphenatethis.gui.config import HyphenateThisConfigWidget
        return HyphenateThisConfigWidget()
    
    def save_settings(self, config_widget):
        config_widget.save_settings()
      # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.changeConfig()
