# Values that are used in both __init__.py and objects.py

import html
import locale

TYPE_TO_TAG = {
    "ANTHOLOGY": "anthology",
    "CHAPBOOK": "chapbook",
    "COLLECTION": "collection",
    "ESSAY": "essay",
    "FANZINE": "fanzine",
    "MAGAZINE": "magazine",
    "NONFICTION": "non-fiction",
    "NOVEL": "novel",
    "NOVEL\n [non-genre]": "novel",
    "NOVEL\n [juvenile]": "juvenile, novel",
    "OMNIBUS": "omnibus",
    "POEM": "poem",
    "SERIAL": "serial",
    "SHORTFICTION": "short fiction",
    "SHORTFICTION\n [juvenile]": "juvenile, short fiction",
    "SHORTFICTION\n [non-genre]": "short fiction"
}

LOCALE_LANGUAGE_CODE, LOCALE_ENCODING = locale.getlocale()  # ('en_GB', 'cp1252')
if LOCALE_LANGUAGE_CODE is None:
    LOCALE_LANGUAGE_CODE = 'en_US'
LOCALE_COUNTRY = LOCALE_LANGUAGE_CODE[-2:]
if LOCALE_ENCODING is None:
    LOCALE_ENCODING = 'utf-8'

# book languages from the ISFDB Database (ISO-639-2-Codes, same as Calibre uses)
LANGUAGES = {
    'Afrikaans': 'afr',
    'Albanian': 'alb',
    'Ancient Greek': 'grc',
    'Arabic': 'ara',
    'Armenian': 'arm',
    'Azerbaijani': 'aze',
    'Basque': 'baq',
    'Belarusian': 'bel',
    'Bengali': 'ben',
    'Bulgarian': 'bul',
    'Burmese': 'bur',
    'Catalan': 'cat',
    'Chinese': 'chi',
    'Czech': 'cze',
    'Danish': 'dan',
    'Dutch': 'dut',
    'English': 'eng',
    'Esperanto': 'epo',
    'Estonian': 'est',
    'Filipino': 'fil',
    'Finnish': 'fin',
    'French': 'fre',
    'Frisian': 'fry',
    'Galician': 'glg',
    'Georgian': 'geo',
    'German': 'ger',
    'Greek': 'gre',
    'Gujarati': 'guj',
    'Hebrew': 'heb',
    'Hindi': 'hin',
    'Croatian': 'hrv',
    'Hungarian': 'hun',
    'Icelandic': 'ice',
    'Indonesian': 'ind',
    'Irish': 'gle',
    'Italian': 'ita',
    'Japanese': 'jpn',
    'Kazakh': 'kaz',
    'Khmer': 'khm',
    'Kyrgyz': 'kir',
    'Korean': 'kor',
    'Latvian': 'lav',
    'Latin': 'lat',
    'Lithuanian': 'lit',
    'Macedonian': 'mac',
    'Malay': 'may',
    'Malayalam': 'mal',
    'Marathi': 'mar',
    'Mongolian': 'mon',
    'Norwegian': 'nor',
    'Persian': 'per',
    'Polish': 'pol',
    'Portuguese': 'por',
    'Romanian': 'rum',
    'Russian': 'rus',
    'Scottish Gaelic': 'gla',
    'Slovak': 'slo',
    'Slovenian': 'slv',
    'Spanish': 'spa',
    'Serbian': 'srp',
    'Sinhalese': 'sin',
    'Swedish': 'swe',
    'Tajik': 'tgk',
    'Tamil': 'tam',
    'Thai': 'tha',
    'Tibetan': 'tib',
    'Turkish': 'tur',
    'Ukrainian': 'ukr',
    'Urdu': 'urd',
    'Uzbek': 'uzb',
    'Vietnamese': 'vie',
    'Welsh': 'wel',
    'Yiddish': 'yid',
    'Amharic': 'amh',
    'Bosnian': 'bos',
    'Hausa': 'hau',
    'Hawaiian': 'haw',
    'Javanese': 'jav',
    'Judeo-Arabic': 'jrb',
    'Karen': 'kar',
    'Ladino': 'lad',
    'Maltese': 'mlt',
    'Minangkabau': 'min',
    'Nyanja': 'nya',
    'Panjabi': 'pan',
    'Samoan': 'smo',
    'Sindhi': 'snd',
    'Somali': 'som',
    'Sundanese': 'sun',
    'Swahili': 'swa',
    'Tagalog': 'tgl',
    'Tatar': 'tat',
    'Telugu': 'tel',
    'Uighur': 'uig',
    'Sanskrit': 'san',
    'Serbo-Croatian Cyrillic': 'scc',
    'Serbo-Croatian Roman': 'scr',
    'Scots': 'sco',
    'Old English': 'ang',
    'Old French': 'fro',
    'Middle English': 'enm',
    'Middle High German': 'gmh',
    'Yoruba': 'yor',
    'Mayan language': 'myn',
    'Akkadian': 'akk',
    'Sumerian': 'sux',
    'Norwegian (Bokmal)': 'nob',
    'Norwegian (Nynorsk)': 'nno',
    'Asturian/Bable': 'ast',
    'Middle French': 'frm',
    'Low German': 'nds',
    'Nepali': 'nep',
    'Pashto/Pushto': 'pus',
    'Shona': 'sna',
    'Old Norse': 'non',
    'Nilo-Saharan language': 'ssa',
    'Bambara': 'bam',
    'Bantu language': 'bnt',
    'Niger-Kordofanian language': 'nic',
    'Ewe': 'ewe',
    'Igbo': 'ibo',
    'Kamba': 'kam',
    'Kannada': 'kan',
    'Kikuyu/Gikuyu': 'kik',
    'Kurdish': 'kur',
    'Lingala': 'lin',
    'Creole or pidgin, French-based': 'cpf',
    'Central American Indian language': 'cai',
    'Nandi': 'niq',
    'Creole or pidgin, English-based': 'cpe',
    'Tigre': 'tig',
    'Tigrinya': 'tir',
    'Tsonga': 'tso',
    'Tswana': 'tsn',
    'Zulu': 'zul',
    'Acoli': 'ach',
    'Fulah': 'ful',
    'Ganda': 'lug',
    'Kinyarwanda': 'kin',
    'Luo': 'luo',
    'Mandingo': 'man',
    'Oriya': 'ori',
    'Pedi/Sepedi/Northern Sotho': 'nso',
    'South Ndebele': 'nbl',
    'Southern Sotho': 'sot',
    'Standard Moroccan Tamazight': 'zgh',
    'Wolof': 'wol',
    'North Ndebele': 'nde',
    'Montenegrin': 'cnr',
    'Mirandese': 'mwl',
    'Lao': 'lao',
    'South American Indian language': 'sai',
    'Interlingua': 'ina',
    'Guarani': 'grn',
    'Maithili': 'mai',
    'Romance language': 'roa',
    'Klingon': 'tlh',
}

# Book identifiers.
# The fields are: Calibre identifier type, description from ISFDB, base link for identifier value.
biblioman = html.unescape('&#1041;&#1080;&#1073;&#1083;&#1080;&#1086;&#1084;&#1072;&#1085; (Biblioman)')
EXTERNAL_IDS = {
    # Keys came from the identifier_types table of ISFDB,
    # the values came from the publication record External IDs field
    'ASIN': ['asin', 'Amazon Standard Identification Number', 'https://www.amazon.com/dp/'],
    'Audible-ASIN': ['audible-asin', 'Audible ASIN', ''],
    'Biblioman': ['biblioman', biblioman, ''],
    'BL': ['bl', 'The British Library', ''],
    'Bleiler Gernsback': ['bleiler-gernsback',
                          'Everett F. Bleiler, Richard Bleiler. Science-Fiction: The Gernsback Years. '
                          'Kent State University Press, 1998, xxxii+730pp', ''],
    'Bleiler Supernatural': ['bleiler-supernatural',
                             'Everett F. Bleiler. The Guide to Supernatural Fiction. '
                             'Kent State University Press, 1983, xii+723 p.', ''],
    'Bleiler Early Years': ['bleiler-early-years',
                            'Richard Bleiler, Everett F. Bleiler. Science-Fiction: The Early Years. Kent State '
                            'University Press, 1991, xxiii+998 p.', ''],
    'BN': ['bn', 'Barnes and Noble', 'http://www.barnesandnoble.com/s/'],
    'BNB': ['bnb', 'The British National Bibliography', ''],
    'BNF': ['bnf', 'Bibliothèque nationale de France', ''],
    'COBISS.BG': ['cobiss-bg', 'Co-operative Online Bibliographic Systems and Services - Bulgaria', ''],
    'COBISS.SR': ['cobiss-sr', 'Co-operative Online Bibliographic Systems and Services - Serbia', ''],
    'DNB': ["dnb", "Deutsche Nationalbibliothek", "http://d-nb.info/"],
    'Goodreads': ['goodreads', 'Goodreads social cataloging site', ''],
    'JNB/JPNO': ['jnb-jpno', 'The Japanese National Bibliography', ''],
    'KBR': ['kbr', 'De Belgische Bibliografie/La Bibliographie de Belgique', ''],
    'LCCN': ['lccn', 'Library of Congress Control Number', ''],
    'Libris': ['libris', 'Libris - National Library of Sweden', ''],
    'Libris XL': ['libris-xl', 'Libris XL - National Library of Sweden (new interface)', ''],
    'NILF': ['nilf', 'Numero Identificativo della Letteratura Fantastica / Fantascienza', ''],
    'NLA': ['nla', 'National Library of Australia', ''],
    'NooSFere': ['noosfere', 'NooSFere', ''],
    'OCLC/WorldCat': ["oclc", "Online Computer Library Center", "http://www.worldcat.org/oclc/"],
    'Open Library': ['open-library', 'Open Library', ''],
    'PORBASE': ['porbase', 'Biblioteca Nacional de Portugal', ''],
    'PPN': ['ppn', 'De Nederlandse Bibliografie Pica Productie Nummer', ''],
    'Reginald-1': ['reginald-1', 'R. Reginald. Science Fiction and Fantasy Literature: A Checklist, 1700-1974, '
                                 'with Contemporary Science Fiction Authors II. Gale Research Co., 1979, 1141p.', ''],
    'Reginald-3': ['reginald-3', 'Robert Reginald. Science Fiction and Fantasy Literature, 1975-1991: '
                                 'A Bibliography of Science Fiction, Fantasy, and Horror Fiction Books and Nonfiction '
                                 'Monographs. Gale Research Inc., 1992, 1512 p.', ''],
    'SF-Leihbuch': ['sf-leihbuch', 'Science Fiction-Leihbuch-Datenbank', ''],
    # Key came from the publication record ISBN field
    'ISBN': ['isbn', 'International Standard Book Number (10 or 13)', 'https://www.worldcat.org/isbn/'],
}

# Keys that came from Calibre source code
# CALIBRE_IDS = {
#     'arXiv': ['arxiv', 'An open-access repository of electronic preprints and postprints.', 'https://arxiv.org/abs/'],
#     'DOI': ["doi", "Digital Object Identifier", "https://dx.doi.org/"],
#     'ISBN': ['isbn', 'International Standard Book Number (10 or 13)', 'https://www.worldcat.org/isbn/'],
#     'ISSN': ['issn', 'International Standard Serial Number', 'https://www.worldcat.org/issn/'],
#     "URI": ['uri', 'Uniform Resource Identifier', ''],
#     "URL": ['url', 'Uniform Resource Locator', ''],
# }
# EXTERNAL_IDS.update(CALIBRE_IDS)

# Identifier types in Calibre format from the identifier_types table of isfdb
IDENTIFIER_TYPES = {}
for identifier_list in EXTERNAL_IDS.items():
    # Calibre identifier type and identifier description
    IDENTIFIER_TYPES.update({identifier_list[0]: identifier_list[1]})

# ToDo: Set link for identifiers? See: # https://github.com/kovidgoyal/calibre/src/calibre/gui2/dialogs/book_info.py


# Create a dummy function for poedit to fetch the untranslated stings (see docs.python.org)
def _(message): return message


# Strings from isfdb.org page to be translated
TRANSLATION_REPLACINGS = [
    _('the book has no ISBN, since it was not available in regular book shops'),
    _('There\'s no statement for the date of publication'),
    _('No indication for the date of publication'),
    _('No statement for the date of publication'),
    _('The day of publication from the monthly schedule'),
    _('Day of publication from the monthly schedule'),
    _('The day of publication from the weekly schedule'),
    _('Day of publication from the weekly schedule'),
    _('The publication date is deduced from'),
    _('First (and probably only) printing'),
    _('The page count begins with the cover'),
    _('the last story ends on this page'),
    _('A most likely abridged re-edition'),
    _('An abridged reprint of the'),
    _('First German edition and printing'),
    _('First German edition'),
    _('The cover artist is not credited'),
    _('The interior art is not credited'),
    _('identified by his unique style'),
    _('Published simultaneously with'),
    _('The table of contents appears'),
    _('No credit for cover art'),
    _('there is no visible signature'),
    _('no visible signature'),
    _('stated on the copyright page'),
    _('No credit for the cover art'),
    _('on the cover and the spine'),
    _('Cover design credited to'),
    _('There is no interior art'),
    _('A selected bibliography'),
    _('Apparent first printing'),
    _('Translation copyrighted'),
    _('visible in the cover\'s'),
    _('(view Concise Listing)'),
    _('The not numbered pages'),
    _('Cover artist credited'),
    _('It could very well be'),
    _('It could very well be'),
    _('not explicitly stated'),
    _('on the copyright page'),
    _('on the cover\'s lower left border'),
    _('The copyright is assigned for the year'),
    _('has a teaser for the next number'),
    _('to the author'),
    _('Stated first printing'),
    _('Most likely abridged'),
    _('publication schedule'),
    _('Month of publication'),
    _('did the majority of'),
    _('is clearly visible'),
    _('A table of contents'),
    _('publication series'),
    _('but his signature'),
    _('interior artwork'),
    _('is referenced via'),
    _('on the title page'),
    _('Possibly abridged'),
    _('Table of contents'),
    _('Abridged reprint'),
    _('interior artwork'),
    _('this translation'),
    _('was published in'),
    _('Author\'s Note'),
    _('Basic data from'),
    _('second printing'),
    _('the fortnightly'),
    _('the four-weekly'),
    _('first printing'),
    _('Original title'),
    _('The Page count'),
    _('the title page'),
    _('with the cover'),
    _('calender week'),
    _('First edition and printing'),
    _('First edition'),
    _('First printing'),
    _('identified by'),
    _('special price'),
    _('The cover art'),
    _('Translated by'),
    _('Cover artist'),
    _('interior art'),
    _('is stated on'),
    _('not stated'),
    _('on the cover'),
    _('on the spine'),
    _('Other prices'),
    _('short story'),
    _('the 4-weekly'),
    _('of a month'),
    _(' dedicated '),
    _('Netherlands'),
    _('Other price'),
    _('Switzerland'),
    _('this number'),
    _('uncredited'),
    _('unpaginated'),
    _('The unpaginated'),
    _('<b>and</b>'),
    _('Collection'),
    _('collection'),
    _('Month from'),
    _('noveletta'),
    _('rear flap'),
    _('re-edition'),
    _('Romanette'),
    _('the weekly'),
    _('trans. of'),
    _('Translator'),
    _('is not numbered'),
    _('unnumbered'),
    _('variant of'),
    _('Anthology'),
    _('chapbook'),
    _('hardcover edition'),
    _('day from '),
    _('edited by'),
    _('hardvover'),
    _('paperback'),
    _('publisher'),
    _('signature'),
    _('The month'),
    _(' starts '),
    _(' states '),
    _('ad pages'),
    _('Chapbook'),
    _('Contents'),
    _('credited'),
    _('Day from'),
    _('novella'),
    _('omnibus'),
    _('or later'),
    _('Possibly'),
    _('schedule'),
    _(' corner'),
    _(' cover '),
    _(' pages '),
    _(' upper '),
    _('ad page'),
    _('Austria'),
    _('deduced'),
    _('edition'),
    _('Omnibus'),
    _('review'),
    _('The day'),
    _('various'),
    _(' appears '),
    _(' from '),
    _(' left '),
    _(' page '),
    _('Editor'),
    _('essay'),
    _('novel'),
    _('Title'),
    _(' are '),
    _(' bep '),
    _('as by'),
    _('Italy'),
    _(' p. '),
    _('fep'),
    _('Pp.'),
    _('P.'),
]

del _  # delete the dummy function
