#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
try:
    load_translations()
except NameError:
    pass

__license__ = 'GPL v3'
__copyright__ = '2024, Dunhill'
__docformat__ = 'restructuredtext en'

import os
from calibre.gui2.actions import InterfaceAction
from .main import Dialog  # Importación relativa desde el paquete raíz
from . import common_icons

class InterfacePlugin(InterfaceAction):
    name = 'Theme Switcher'
    action_spec = ('Theme Switcher', None, _('Run Theme Switcher'), None)

    def genesis(self):
        icon_resources = {}
        for icon_name in ['icon.png', 'icon_dark.png', 'icon_light.png']:
            icon_path = os.path.join('images', icon_name)
            try:
                with open(icon_path, 'rb') as f:
                    icon_resources[icon_path] = f.read()
            except FileNotFoundError:
                print(f"Warning: Icon {icon_path} not found, using default icon.")
        common_icons.set_plugin_icon_resources(self.name, icon_resources)

        icon = common_icons.get_icon('images/icon.png')
        if icon and not icon.isNull():
            self.qaction.setIcon(icon)
        else:
            print("Warning: Failed to load icon, using default.")

        self.qaction.triggered.connect(self.show_dialog)

    def show_dialog(self):
        base_plugin_object = self.interface_action_base_plugin
        do_user_config = base_plugin_object.do_user_config
        d = Dialog(self.gui, self.qaction.icon(), do_user_config)
        d.exec_()  # Usar exec_() para diálogo modal

    def apply_settings(self):
        pass
