#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2024, Your Name <your.email@example.com>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class ThemeSwitcher(InterfaceActionBase):
    name                = 'Theme Switcher'
    description         = 'Permite seleccionar y aplicar paletas de colores (.calibre.palette) desde la carpeta de configuración de Calibre'
    supported_platforms = ['windows', 'osx', 'linux']
    author              = 'Dunhill'
    version             = (1, 0, 0)
    minimum_calibre_version = (5, 0, 0)

    actual_plugin       = 'calibre_plugins.theme_switcher.ui:InterfacePlugin'

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.theme_switcher.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
