/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.css.util.FakeFile;
import org.w3c.css.util.Util;

public class Codecs {
    private static boolean debugMode = false;

    private Codecs() {
    }

    public static final synchronized ArrayList<Pair<String, ?>> mpFormDataDecode(byte[] data, String cont_type) throws IOException {
        ArrayList pList = new ArrayList();
        String bndstr = Codecs.getParameter("boundary", cont_type);
        if (bndstr == null) {
            throw new IOException("'boundary' parameter not found in Content-type: " + cont_type);
        }
        byte[] srtbndry = new byte[bndstr.length() + 4];
        byte[] boundary = new byte[bndstr.length() + 6];
        byte[] endbndry = new byte[bndstr.length() + 6];
        srtbndry = ("--" + bndstr + "\n").getBytes(StandardCharsets.ISO_8859_1);
        boundary = ("\n--" + bndstr + "\n").getBytes(StandardCharsets.ISO_8859_1);
        endbndry = ("\n--" + bndstr + "--").getBytes(StandardCharsets.ISO_8859_1);
        if (debugMode) {
            System.err.println("[START OF DATA]");
            Codecs.printData(data);
            System.err.println("[END OF DATA]");
            System.err.print("boundary : ");
            Codecs.printData(srtbndry);
            System.err.println();
            Codecs.printData(boundary);
            System.err.println();
            Codecs.printData(endbndry);
            System.err.println();
        }
        int[] bs = Util.compile_search(srtbndry);
        int[] bc = Util.compile_search(boundary);
        int[] be = Util.compile_search(endbndry);
        int start = Util.findStr(srtbndry, bs, data, 0, data.length);
        if (start == -1) {
            if (!debugMode) {
                debugMode = true;
                Codecs.mpFormDataDecode(data, cont_type);
                return null;
            }
            debugMode = false;
            throw new IOException("Starting boundary not found: " + new String(srtbndry));
        }
        start += srtbndry.length;
        boolean done = false;
        int idx = 0;
        while (!done) {
            Object value;
            int next;
            int end = Util.findStr(boundary, bc, data, start, data.length);
            if (end == -1) {
                end = Util.findStr(endbndry, be, data, start, data.length);
                if (end == -1) {
                    for (end = data.length - 1; end >= 0 && (data[end] == 10 || data[end] == 32); --end) {
                    }
                    ++end;
                }
                done = true;
            }
            String name = null;
            String filename = null;
            String cont_disp = null;
            String mimeType = null;
            while ((next = Codecs.findEOL(data, start) + 1) - 1 > start) {
                String lchdr;
                byte ch;
                String hdr = new String(data, start, next - 1 - start);
                if (debugMode) {
                    System.err.println(" start = " + start + " end = " + next);
                }
                while (next < data.length - 1 && ((ch = data[next]) == 32 || ch == 9)) {
                    next = Codecs.findEOL(data, start) + 1;
                    String result = new String(data, start, next - 1 - start);
                    hdr = hdr + result;
                    start = next;
                }
                start = next;
                if (debugMode) {
                    System.err.println("hdr=" + hdr);
                    System.err.println("(New) start = " + start + " end = " + next);
                }
                if ((lchdr = hdr.toLowerCase()).startsWith("content-type")) {
                    mimeType = lchdr.substring("content-type: ".length());
                    continue;
                }
                if (!lchdr.startsWith("content-disposition")) continue;
                int off = lchdr.indexOf("form-data", 20);
                if (off == -1) {
                    if (!debugMode) {
                        debugMode = true;
                        Codecs.mpFormDataDecode(data, cont_type);
                        return null;
                    }
                    debugMode = false;
                    throw new IOException("Expected 'Content-Disposition: form-data' in line: " + hdr);
                }
                name = Codecs.getParameter("name", hdr);
                if (debugMode) {
                    System.err.println("[ADD name is " + name + ']');
                }
                if (name == null) {
                    if (!debugMode) {
                        debugMode = true;
                        Codecs.mpFormDataDecode(data, cont_type);
                        return null;
                    }
                    debugMode = false;
                    throw new IOException("'name' parameter not found in header: " + hdr);
                }
                filename = Codecs.getParameter("filename", hdr);
                if (debugMode) {
                    System.err.println("[ADD filename is " + filename + ']');
                }
                cont_disp = hdr;
            }
            ++start;
            if (debugMode) {
                System.err.println("(End) start = " + start + " end = " + end);
            }
            if (start > end) {
                if (!debugMode) {
                    debugMode = true;
                    Codecs.mpFormDataDecode(data, cont_type);
                    return null;
                }
                debugMode = false;
                throw new IOException("End of header not found at offset " + end);
            }
            if (cont_disp == null) {
                if (!debugMode) {
                    debugMode = true;
                    Codecs.mpFormDataDecode(data, cont_type);
                    return null;
                }
                debugMode = false;
                throw new IOException("Missing 'Content-Disposition' header at offset " + start);
            }
            if (filename != null) {
                FakeFile file = new FakeFile(filename);
                file.write(data, start, end - start);
                file.setContentType(mimeType);
                value = file;
            } else if (name.equals("text")) {
                try {
                    CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                    decoder.decode(ByteBuffer.wrap(data, start, end - start));
                    value = new String(data, start, end - start, StandardCharsets.UTF_8);
                    pList.add(new ImmutablePair<String, Charset>("textcharset", StandardCharsets.UTF_8));
                }
                catch (CharacterCodingException ignoredEx) {
                    value = new String(data, start, end - start, StandardCharsets.ISO_8859_1);
                    pList.add(new ImmutablePair<String, Charset>("textcharset", StandardCharsets.ISO_8859_1));
                }
            } else {
                value = new String(data, start, end - start, StandardCharsets.ISO_8859_1);
            }
            if (!name.equals("textcharset")) {
                pList.add(new ImmutablePair<String, Object>(name, value));
            }
            if (debugMode) {
                System.err.println("[ADD " + name + ',' + value + ',' + value.getClass() + ']');
            }
            start = end + boundary.length;
            ++idx;
        }
        return pList;
    }

    public static final String getParameter(String param, String hdr) {
        int vbeg;
        int pend;
        int pbeg;
        int vend = -1;
        int len = hdr.length();
        param = param.trim();
        do {
            if (debugMode) {
                System.err.println("[DEBUG] looks for " + param + " in ");
                System.err.println("[" + hdr.substring(vend + 1) + ']');
            }
            if (vend == -1) {
                pbeg = hdr.indexOf(59, vend + 1);
                if (pbeg == -1) {
                    return null;
                }
            } else {
                pbeg = vend + 1;
            }
            while (pbeg < len - 1 && (Character.isWhitespace(hdr.charAt(pbeg)) || hdr.charAt(pbeg) == ';')) {
                ++pbeg;
            }
            if (pbeg == len - 1) {
                return null;
            }
            pend = hdr.indexOf(61, pbeg + 1);
            if (pend == -1) {
                return null;
            }
            vbeg = pend + 1;
            while (Character.isWhitespace(hdr.charAt(--pend))) {
            }
            ++pend;
            if (debugMode) {
                System.err.println("[DEBUG] p is [" + hdr.substring(pbeg, pend) + "]");
            }
            while (vbeg < len && Character.isWhitespace(hdr.charAt(vbeg))) {
                ++vbeg;
            }
            if (vbeg == len) {
                return null;
            }
            vend = vbeg;
            if (hdr.charAt(vbeg) == '\"') {
                if ((vend = hdr.indexOf(34, ++vbeg)) != -1) continue;
                return null;
            }
            vend = hdr.indexOf(59, vbeg);
            if (vend == -1) {
                vend = hdr.length();
            }
            while (Character.isWhitespace(hdr.charAt(--vend))) {
            }
            ++vend;
        } while (!hdr.regionMatches(true, pbeg, param, 0, pend - pbeg));
        return hdr.substring(vbeg, vend);
    }

    private static void printData(byte[] data) {
        Codecs.printData(data, 0);
    }

    private static void printData(byte[] data, int offset) {
        for (int i = offset; i < data.length; ++i) {
            if (data[i] == 10 || data[i] == 13) {
                System.err.print("&" + data[i]);
                System.err.println();
                continue;
            }
            System.err.print((char)data[i]);
        }
    }

    private static final int findEOL(byte[] arr, int off) {
        while (off < arr.length - 1 && arr[off++] != 10) {
        }
        return off - 1;
    }
}

