/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssGridAutoRows
extends org.w3c.css.properties.css.CssGridAutoRows {
    public static final CssIdent[] allowed_values;
    public static final String minmax = "minmax";
    public static final String fit_content = "fit-content";

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssGridAutoRows() {
        this.value = initial;
    }

    public CssGridAutoRows(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0 && CssIdent.isCssWide(val.getIdent())) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                values.add(val);
            } else {
                CssGridAutoRows.parseTrackSize(ac, val, this);
                values.add(val);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static CssValue parseTrackSize(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        switch (value.getType()) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 21: {
                return CssGridAutoRows.parseTrackBreadth(ac, value, caller);
            }
            case 11: {
                CssFunction function = value.getFunction();
                String fname = function.getName().toLowerCase();
                if (minmax.equals(fname)) {
                    return CssGridAutoRows.parseMinmaxFunction(ac, function, ArgType.INFLEXIBLE_BREADTH, ArgType.TRACK_BREADTH, caller);
                }
                if (!fit_content.equals(fname)) break;
                return CssGridAutoRows.parseFitContent(ac, function, caller);
            }
        }
        throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
    }

    protected static CssValue parseFixedSize(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        switch (value.getType()) {
            case 4: 
            case 5: 
            case 6: {
                return CssGridAutoRows.parseFixedBreadth(ac, value, caller);
            }
            case 11: {
                CssFunction function = value.getFunction();
                String fname = function.getName().toLowerCase();
                if (minmax.equals(fname)) {
                    try {
                        return CssGridAutoRows.parseMinmaxFunction(ac, function, ArgType.FIXED_BREADTH, ArgType.TRACK_BREADTH, caller);
                    }
                    catch (InvalidParamException ex) {
                        function.getParameters().starts();
                        return CssGridAutoRows.parseMinmaxFunction(ac, function, ArgType.INFLEXIBLE_BREADTH, ArgType.FIXED_BREADTH, caller);
                    }
                }
                if (!fit_content.equals(fname)) break;
                return CssGridAutoRows.parseFitContent(ac, function, caller);
            }
        }
        throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
    }

    protected static CssValue parseTrackBreadth(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        switch (value.getType()) {
            case 5: {
                value.getCheckableValue().checkEqualsZero(ac, caller);
                return value;
            }
            case 4: 
            case 6: 
            case 21: {
                value.getCheckableValue().checkPositiveness(ac, caller);
                return value;
            }
            case 0: {
                if (CssGridAutoRows.getAllowedIdent(value.getIdent()) == null) break;
                return value;
            }
        }
        throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
    }

    protected static CssValue parseInflexibleBreadth(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        switch (value.getType()) {
            case 5: {
                value.getCheckableValue().checkEqualsZero(ac, caller);
                return value;
            }
            case 4: 
            case 6: {
                value.getCheckableValue().checkPositiveness(ac, caller);
                return value;
            }
            case 0: {
                if (CssGridAutoRows.getAllowedIdent(value.getIdent()) == null) break;
                return value;
            }
        }
        throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
    }

    protected static CssValue parseFixedBreadth(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        switch (value.getType()) {
            case 5: {
                value.getCheckableValue().checkEqualsZero(ac, caller);
                return value;
            }
            case 4: 
            case 6: {
                value.getCheckableValue().checkPositiveness(ac, caller);
                return value;
            }
        }
        throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
    }

    protected static CssFunction parseMinmaxFunction(ApplContext ac, CssFunction func, ArgType type1, ArgType type2, CssProperty caller) throws InvalidParamException {
        CssExpression exp = func.getParameters();
        if (exp.getCount() != 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression nex = new CssExpression();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        switch (type1.ordinal()) {
            case 0: {
                nex.addValue(CssGridAutoRows.parseInflexibleBreadth(ac, val, caller));
                break;
            }
            case 1: {
                nex.addValue(CssGridAutoRows.parseTrackBreadth(ac, val, caller));
                break;
            }
            case 2: {
                nex.addValue(CssGridAutoRows.parseFixedBreadth(ac, val, caller));
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        if (op != ',') {
            throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
        }
        nex.setOperator(op);
        exp.next();
        val = exp.getValue();
        switch (type2.ordinal()) {
            case 0: {
                nex.addValue(CssGridAutoRows.parseInflexibleBreadth(ac, val, caller));
                break;
            }
            case 1: {
                nex.addValue(CssGridAutoRows.parseTrackBreadth(ac, val, caller));
                break;
            }
            case 2: {
                nex.addValue(CssGridAutoRows.parseFixedBreadth(ac, val, caller));
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        func.set(minmax, nex);
        return func;
    }

    protected static CssFunction parseFitContent(ApplContext ac, CssFunction func, CssProperty caller) throws InvalidParamException {
        CssExpression exp = func.getParameters();
        if (exp.getCount() != 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = exp.getValue();
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, caller);
                break;
            }
            case 4: 
            case 6: {
                val.getCheckableValue().checkPositiveness(ac, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        func.set(minmax, exp);
        return func;
    }

    public CssGridAutoRows(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_values = new String[]{"min-content", "max-content", "auto"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssGridAutoRows.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }

    protected static enum ArgType {
        INFLEXIBLE_BREADTH,
        TRACK_BREADTH,
        FIXED_BREADTH;

    }
}

