/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssAspectRatio
extends org.w3c.css.properties.css.CssAspectRatio {
    public static final CssIdent auto = CssIdent.getIdent("auto");

    public CssAspectRatio() {
        this.value = initial;
    }

    public CssAspectRatio(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        int ratio_state = 0;
        this.setByUser();
        CssValue dividend = null;
        CssValue divisor = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    if (ratio_state == 0) {
                        dividend = val;
                        ++ratio_state;
                        break;
                    }
                    if (ratio_state == 2) {
                        divisor = val;
                        ++ratio_state;
                        v.add(new CssRatio(dividend, divisor));
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 14: {
                    if (ratio_state == 1) {
                        ++ratio_state;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (inherit.equals(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        v.add(val);
                        break;
                    }
                    if (auto.equals(id)) {
                        v.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (ratio_state == 1) {
            v.add(new CssRatio(dividend));
        } else if (v.isEmpty() || ratio_state != 0 && ratio_state != 3) {
            throw new InvalidParamException("value", expression.toStringFromStart(), this.getPropertyName(), ac);
        }
        if (v.size() > 1) {
            if (((CssValue)v.get(0)).getType() == ((CssValue)v.get(1)).getType()) {
                throw new InvalidParamException("value", v.get(1).toString(), this.getPropertyName(), ac);
            }
            this.value = new CssValueList(v);
        } else {
            this.value = (CssValue)v.get(0);
        }
    }

    public CssAspectRatio(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

