/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.Errors;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;
import org.w3c.css.util.xml.XMLCatalog;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class XMLStyleSheetHandler
implements ContentHandler,
LexicalHandler,
ErrorHandler,
EntityResolver {
    static String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static long autoIdCount;
    String namespaceURI;
    boolean isRoot = true;
    ApplContext ac;
    URL documentURI = null;
    URL baseURI = null;
    StyleSheetParser styleSheetParser = null;
    boolean inStyle = false;
    String media = null;
    String type = null;
    String title = null;
    StringBuilder text = new StringBuilder(255);
    Locator locator;
    static XMLCatalog catalog;

    public XMLStyleSheetHandler(URL baseURI, ApplContext ac) {
        this.documentURI = baseURI;
        this.baseURI = baseURI;
        this.ac = ac;
        this.styleSheetParser = new StyleSheetParser(ac);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.ac.setInput("text/xml");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inStyle) {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.inStyle) {
            int line = this.locator != null ? this.locator.getLineNumber() : -1;
            Warning w = new Warning(this.baseURI.toString(), line, "style-inside-comment", 0, this.ac);
            Warnings warnings = new Warnings(this.ac.getWarningLevel());
            warnings.addWarning(w);
            this.styleSheetParser.notifyWarnings(warnings);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        HashMap<String, String> atts = this.getValues(data);
        if ("xml-stylesheet".equals(target)) {
            String rel = atts.get("alternate");
            String type = atts.get("type");
            String href = atts.get("href");
            if (Util.onDebug) {
                System.err.println("<?xml-stylesheet alternate=\"" + rel + "\" type=\"" + type + "\"   href=\"" + href + "\"?>");
            }
            rel = "yes".equalsIgnoreCase(rel) ? "alternate stylesheet" : "stylesheet";
            if (href == null) {
                int line = -1;
                if (this.locator != null) {
                    line = this.locator.getLineNumber();
                }
                CssError er = new CssError(this.baseURI.toString(), line, new InvalidParamException("unrecognized.link", this.ac));
                Errors ers = new Errors();
                ers.addError(er);
                this.styleSheetParser.notifyErrors(ers);
            }
            if (href.charAt(0) == '#') {
                return;
            }
            if (type != null) {
                MimeType mt = null;
                try {
                    mt = new MimeType(type);
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (mt != null && MimeType.TEXT_CSS.match(mt) == 4) {
                    String media;
                    URL url;
                    try {
                        url = this.baseURI != null ? new URL(this.baseURI, href) : new URL(href);
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                    if (Util.onDebug) {
                        System.err.println("[XMLStyleSheetHandler::initialize(): should parse CSS url: " + url.toString() + "]");
                    }
                    if ((media = atts.get("media")) == null && this.ac.getCssVersion() != CssVersion.CSS1) {
                        media = "all";
                    }
                    this.styleSheetParser.parseURL(this.ac, url, atts.get("title"), rel, media, 3);
                    if (Util.onDebug) {
                        System.err.println("[parsed!]");
                    }
                }
            }
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isRoot) {
            this.namespaceURI = namespaceURI;
            this.isRoot = false;
        }
        if (XHTML_NS.equals(namespaceURI)) {
            String value;
            if ("base".equals(localName)) {
                String href = atts.getValue("href");
                if (Util.onDebug) {
                    System.err.println("BASE href=\"" + href + "\"");
                }
                if (href != null) {
                    try {
                        this.documentURI = this.baseURI = new URL(this.documentURI, href);
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                }
            } else if ("link".equals(localName)) {
                String rel = atts.getValue("rel");
                String type = atts.getValue("type");
                String href = atts.getValue("href");
                if (Util.onDebug) {
                    System.err.println("link rel=\"" + rel + "\" type=\"" + type + "\"   href=\"" + href + "\"");
                }
                if (type == null) {
                    return;
                }
                MimeType mt = null;
                try {
                    mt = new MimeType(type);
                }
                catch (MimeTypeFormatException mtfe) {
                    return;
                }
                if (MimeType.TEXT_CSS.match(mt) != 4) {
                    return;
                }
                if (href == null) {
                    int line = -1;
                    if (this.locator != null) {
                        line = this.locator.getLineNumber();
                    }
                    CssError er = new CssError(this.baseURI.toString(), line, new InvalidParamException("unrecognized.link", this.ac));
                    Errors ers = new Errors();
                    ers.addError(er);
                    this.styleSheetParser.notifyErrors(ers);
                    return;
                }
                if (rel != null && rel.toLowerCase().indexOf("stylesheet") != -1) {
                    String media;
                    URL url;
                    try {
                        url = this.baseURI != null ? new URL(this.baseURI, href) : new URL(href);
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                    if (Util.onDebug) {
                        System.err.println("[XMLStyleSheetHandler::initialize(): should parse CSS url: " + url.toString() + "]");
                    }
                    if ((media = atts.getValue("media")) == null && this.ac.getCssVersion() != CssVersion.CSS1) {
                        media = "all";
                    }
                    this.styleSheetParser.parseURL(this.ac, url, atts.getValue("title"), rel, media, 3);
                    if (Util.onDebug) {
                        System.err.println("[parsed!]");
                    }
                }
            } else if ("style".equals(localName)) {
                this.media = atts.getValue("media");
                this.type = atts.getValue("type");
                this.title = atts.getValue("title");
                if (this.media == null && this.ac.getCssVersion() != CssVersion.CSS1) {
                    this.media = "all";
                }
                if (Util.onDebug) {
                    System.err.println("style media=\"" + this.media + "\" type=\"" + this.type + "\"   title=\"" + this.title + "\"");
                }
                if (this.type == null) {
                    int line = -1;
                    if (this.locator != null) {
                        line = this.locator.getLineNumber();
                    }
                    CssError er = new CssError(this.baseURI.toString(), line, new InvalidParamException("unrecognized.link", this.ac));
                    Errors ers = new Errors();
                    ers.addError(er);
                    this.styleSheetParser.notifyErrors(ers);
                } else {
                    try {
                        MimeType mt = new MimeType(this.type);
                        if (MimeType.TEXT_CSS.match(mt) == 4) {
                            this.text.setLength(0);
                            this.inStyle = true;
                        }
                    }
                    catch (MimeTypeFormatException mt) {}
                }
            } else if (atts.getValue("style") != null && (value = atts.getValue("style")) != null) {
                String id = atts.getValue("id");
                this.handleStyleAttribute(value, id);
            }
        } else {
            String value = atts.getValue(XHTML_NS, "style");
            if (value != null) {
                String id = atts.getValue(XHTML_NS, "id");
                this.handleStyleAttribute(value, id);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        int line = 0;
        if (this.locator != null) {
            line = this.locator.getLineNumber();
        }
        if (XHTML_NS.equals(namespaceURI) && "style".equals(localName) && this.inStyle) {
            this.inStyle = false;
            if (this.text.length() != 0) {
                if (Util.onDebug) {
                    System.err.println("PARSE [" + this.text.toString() + "]");
                }
                this.styleSheetParser.parseStyleElement(this.ac, new StringReader(this.text.toString()), this.title, this.media, this.documentURI, line);
            }
        }
    }

    public void handleStyleAttribute(String value, String id) {
        if (id == null) {
            StringBuilder sb = new StringBuilder("#autoXML");
            StringBuilder stringBuilder = sb.append(autoIdCount);
            stringBuilder.append(autoIdCount++);
            id = sb.toString();
        }
        int line = 0;
        if (this.locator != null) {
            line = this.locator.getLineNumber();
        }
        this.styleSheetParser.parseStyleAttribute(this.ac, new ByteArrayInputStream(value.getBytes()), id, this.documentURI, line);
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheetParser.getStyleSheet();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String uri = null;
        if (publicId != null) {
            if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(publicId)) {
                if (!"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd".equals(systemId) && this.ac != null && this.ac.getFrame() != null) {
                    this.ac.getFrame().addWarning("xhtml.system_identifier.invalid");
                }
            } else if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(publicId)) {
                if (!"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(systemId) && this.ac != null && this.ac.getFrame() != null) {
                    this.ac.getFrame().addWarning("xhtml.system_identifier.invalid");
                }
            } else if ("-//W3C//DTD XHTML 1.0 Frameset//EN".equals(publicId) && !"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd".equals(systemId) && this.ac != null && this.ac.getFrame() != null) {
                this.ac.getFrame().addWarning("xhtml.system_identifier.invalid");
            }
            uri = catalog.getProperty(publicId);
        }
        if (uri == null && systemId != null) {
            uri = catalog.getProperty(systemId);
        }
        if (uri != null) {
            return new InputSource(uri);
        }
        return new InputSource(new URL(this.baseURI, systemId).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(URL url) throws Exception {
        InputSource source = new InputSource();
        SAXParser xmlParser = new SAXParser();
        try {
            xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlParser.setFeature("http://xml.org/sax/features/validation", false);
            xmlParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xmlParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        xmlParser.setContentHandler(this);
        URLConnection connection = HTTPURL.getConnection(url, this.ac);
        InputStream in = HTTPURL.getInputStream(this.ac, connection);
        String streamEncoding = HTTPURL.getCharacterEncoding(this.ac, connection);
        String httpCL = connection.getHeaderField("Content-Location");
        if (httpCL != null) {
            this.documentURI = this.baseURI = HTTPURL.getURL(this.baseURI, httpCL);
            if (streamEncoding != null) {
                this.ac.setCharsetForURL(this.baseURI, streamEncoding, false);
            }
        }
        if (streamEncoding != null) {
            source.setEncoding(streamEncoding);
        }
        source.setByteStream(in);
        URL ref = this.ac.getReferrer();
        try {
            this.ac.setReferrer(this.documentURI);
            xmlParser.parse(url.toString());
        }
        finally {
            this.ac.setReferrer(ref);
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(String urlString, URLConnection connection) throws Exception {
        SAXParser xmlParser = new SAXParser();
        try {
            xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlParser.setFeature("http://xml.org/sax/features/validation", false);
            xmlParser.setErrorHandler(this);
            xmlParser.setEntityResolver(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        xmlParser.setContentHandler(this);
        InputStream cis = HTTPURL.getInputStream(this.ac, connection);
        InputSource source = new InputSource(cis);
        String streamEncoding = HTTPURL.getCharacterEncoding(this.ac, connection);
        String httpCL = connection.getHeaderField("Content-Location");
        if (httpCL != null) {
            this.documentURI = this.baseURI = HTTPURL.getURL(this.baseURI, httpCL);
            if (streamEncoding != null) {
                this.ac.setCharsetForURL(this.baseURI, streamEncoding, false);
            }
        }
        if (streamEncoding != null) {
            source.setEncoding(streamEncoding);
        }
        source.setSystemId(urlString);
        URL ref = this.ac.getReferrer();
        try {
            this.ac.setReferrer(this.documentURI);
            xmlParser.parse(source);
        }
        finally {
            this.ac.setReferrer(ref);
            cis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source, String fileName) throws IOException, SAXException {
        SAXParser xmlParser = new SAXParser();
        try {
            xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlParser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        xmlParser.setContentHandler(this);
        if (fileName != null) {
            this.baseURI = new URL(fileName);
            this.documentURI = new URL(fileName);
            source.setSystemId(fileName);
        }
        URL ref = this.ac.getReferrer();
        try {
            this.ac.setReferrer(this.documentURI);
            xmlParser.parse(source);
        }
        finally {
            this.ac.setReferrer(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream is, String docref) throws IOException, SAXException {
        InputSource inputSource = new InputSource(is);
        try {
            this.parse(inputSource, docref);
        }
        finally {
            is.close();
        }
    }

    public void parse(Reader reader) throws IOException, SAXException {
        InputSource inputSource = new InputSource(reader);
        try {
            this.parse(inputSource, null);
        }
        finally {
            reader.close();
        }
    }

    HashMap<String, String> getValues(String data) {
        int length = data.length();
        StringBuilder name = new StringBuilder(10);
        StringBuilder value = new StringBuilder(128);
        StringBuilder entity_name = new StringBuilder(16);
        int state = 0;
        HashMap<String, String> table = new HashMap<String, String>();
        block36: for (int current = 0; current < length; ++current) {
            char c = data.charAt(current);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            continue block36;
                        }
                        case '\"': 
                        case '\'': {
                            return table;
                        }
                        case 'a': 
                        case 'c': 
                        case 'h': 
                        case 'm': 
                        case 'r': 
                        case 't': {
                            name.setLength(0);
                            value.setLength(0);
                            name.append(c);
                            state = 1;
                            continue block36;
                        }
                    }
                    return table;
                }
                case 1: {
                    if (c >= 'a' && c <= 'z') {
                        name.append(c);
                        continue block36;
                    }
                    if (c == ' ' || c == '\t' || c == '\n') {
                        state = 2;
                        continue block36;
                    }
                    if (c == '=') {
                        state = 3;
                        continue block36;
                    }
                    state = 0;
                    continue block36;
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            continue block36;
                        }
                        case '=': {
                            state = 3;
                        }
                    }
                    return table;
                }
                case 3: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            continue block36;
                        }
                        case '\"': {
                            state = 4;
                            continue block36;
                        }
                        case '\'': {
                            state = 5;
                            continue block36;
                        }
                    }
                    return table;
                }
                case 4: 
                case 5: {
                    switch (c) {
                        case '&': {
                            entity_name.setLength(0);
                            state += 10;
                            continue block36;
                        }
                        case '<': {
                            return table;
                        }
                        case '\"': {
                            if (state == 4) {
                                state = 6;
                                continue block36;
                            }
                            value.append(c);
                            continue block36;
                        }
                        case '\'': {
                            if (state == 5) {
                                state = 6;
                                continue block36;
                            }
                            value.append(c);
                            continue block36;
                        }
                    }
                    value.append(c);
                    continue block36;
                }
                case 6: {
                    table.put(name.toString(), value.toString());
                    name.setLength(0);
                    value.setLength(0);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            state = 0;
                            continue block36;
                        }
                    }
                    return table;
                }
                case 14: 
                case 15: {
                    switch (c) {
                        case 'a': 
                        case 'g': 
                        case 'l': 
                        case 'm': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 's': 
                        case 't': 
                        case 'u': {
                            entity_name.append(c);
                            continue block36;
                        }
                        case ';': {
                            String entity = entity_name.toString();
                            if ("amp".equals(entity)) {
                                value.append('&');
                            } else if ("lt".equals(entity)) {
                                value.append('<');
                            } else if ("gt".equals(entity)) {
                                value.append('>');
                            } else if ("quote".equals(entity)) {
                                value.append('\"');
                            } else if ("apos".equals(entity)) {
                                value.append('\'');
                            } else {
                                return table;
                            }
                            state -= 10;
                            continue block36;
                        }
                    }
                    return table;
                }
            }
        }
        if (name.length() != 0 && value.length() != 0) {
            table.put(name.toString(), value.toString());
        }
        return table;
    }

    static {
        catalog = new XMLCatalog();
    }
}

