/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.generic.EscapeTool;
import org.w3c.css.css.CssRuleList;
import org.w3c.css.css.CssValidator;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.error.ErrorReportHTML;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Warnings;

public class StyleSheetGenerator
extends StyleReport {
    private PrintWriter out;
    private Template template;
    private String template_file;
    private String default_lang = "en";
    private ApplContext ac;
    private StyleSheet style;
    private String title;
    private VelocityContext context;
    private Warnings warnings;
    private Errors errors;
    private static final Utf8Properties availableFormat;
    private static final Utf8Properties availablePropertiesURL;
    private static ToolManager velocityToolManager;

    public StyleSheetGenerator(String title, StyleSheet style, String document, int warningLevel) {
        this(null, title, style, document, warningLevel);
    }

    public StyleSheetGenerator(ApplContext ac, String title, StyleSheet style, String document, int warningLevel) {
        String k;
        this.ac = ac;
        this.style = style;
        this.title = title;
        this.template_file = availableFormat.getProperty(document);
        this.context = new VelocityContext(velocityToolManager.createContext());
        this.context.put("esc", new EscapeTool());
        this.context.put("Messages", Messages.class);
        if (ac.isInputFake()) {
            title = title.substring(title.lastIndexOf(47) + 1);
        }
        this.context.put("file_title", this.queryReplace(title));
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        ArrayList<CssRuleList> items = style.newGetRules();
        ApplContext ac_default = new ApplContext(this.default_lang);
        if (ac.getLang() == null || ac.getLang().equals(this.default_lang)) {
            for (Object s : ac_default.getMsg().properties.keySet()) {
                k = String.valueOf(s);
                this.context.put(k, ac.getMsg().getString(k));
            }
        } else {
            for (Object s : ac_default.getMsg().properties.keySet()) {
                k = String.valueOf(s);
                String v = ac.getMsg().getString(k);
                this.context.put(k, v == null ? ac_default.getMsg().getString(k) : v);
            }
        }
        if (ac.getLink() != null) {
            int arraysize = Messages.languages_name.size();
            ArrayList languages = new ArrayList(arraysize);
            for (int i = 0; i < arraysize; ++i) {
                String name = String.valueOf(Messages.languages_name.get(i));
                HashMap<String, String> l = new HashMap<String, String>();
                l.put("name", name);
                l.put("real", Messages.languages.get(name).getProperty("language_name"));
                languages.add(i, l);
            }
            this.context.put("languages", languages.toArray());
            String link = ac.getLink().replaceAll("&lang=.*&", "&");
            link = link.replaceAll("&lang=.*$", "");
            this.context.put("link", "?" + link.replaceAll("&", "&amp;"));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date now = new Date();
        this.context.put("currentdate", formatter.format(now));
        this.context.put("currentdatelong", now.getTime());
        this.context.put("lang", ac.getContentLanguage());
        this.context.put("errors_count", this.errors.getErrorCount());
        this.context.put("warnings_count", this.warnings.getWarningCount());
        this.context.put("ignored-warnings_count", this.warnings.getIgnoredWarningCount());
        this.context.put("warning_level", warningLevel);
        this.context.put("rules_count", items.size());
        this.context.put("no_errors_report", Boolean.FALSE);
        this.context.put("charset", ac.getContentEncoding());
        this.context.put("cssversion", ac.getCssVersionString());
        this.context.put("css_profile", ac.getProfileString());
        if (ac.getCssProfile() == CssProfile.EMPTY) {
            this.context.put("css", ac.getMsg().getString(ac.getCssVersionString()));
        } else {
            this.context.put("css", ac.getMsg().getString(ac.getCssVersionString()) + " + " + ac.getMsg().getString(ac.getCssProfile().toString()));
        }
        this.context.put("css_link", StyleSheetGenerator.getURLProperty("@url-base_" + ac.getCssVersionString()));
        this.context.put("is_valid", this.errors.getErrorCount() == 0 ? "true" : "false");
        this.context.put("fake_input", ac.isInputFake());
        this.context.put("author", "www-validator-css");
        this.context.put("author-email", "Email.html");
        if (style.charset != null) {
            this.context.put("style_charset", style.charset);
        }
        this.produceError();
        this.produceWarning();
        if (CssValidator.showCSS) {
            this.produceStyleSheet();
        }
        try {
            String _template_dir = "org/w3c/css/css/";
            this.template = Velocity.getTemplate(_template_dir + this.template_file);
            this.template.setEncoding("utf-8");
        }
        catch (ResourceNotFoundException rnfe) {
            System.err.println(rnfe.getMessage());
            rnfe.printStackTrace();
        }
        catch (ParseErrorException pee) {
            System.err.println(pee.getMessage());
            pee.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static final String getURLProperty(String name) {
        return availablePropertiesURL.getProperty(name);
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.println("Format : " + key);
            out.println("   File : " + StyleSheetGenerator.getDocumentName(key));
        }
        out.flush();
    }

    public static String printAvailableFormatList(String def) {
        Enumeration<?> e = availableFormat.propertyNames();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> t = Collections.list(e);
        Collections.sort(t);
        boolean isFirst = true;
        for (String s : t) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(s);
            if (!s.equals(def)) continue;
            sb.append(" (default)");
        }
        return sb.toString();
    }

    public static boolean isAvailableFormat(String document) {
        return availableFormat.containsKey(document);
    }

    private static final String getDocumentName(String documentName) {
        String document = availableFormat.getProperty(documentName.toLowerCase());
        if (document == null) {
            System.err.println("Unable to find " + documentName.toLowerCase() + " output format");
            return documentName;
        }
        return document;
    }

    private void produceStyleSheet() {
        this.context.put("at_rules_list", this.style.newGetRules());
    }

    private void produceError() {
        Hashtable[] errors_content = new Hashtable[this.errors.getErrorCount()];
        try {
            if (this.errors.getErrorCount() != 0) {
                for (CssError csserror : this.errors.getErrors()) {
                    Hashtable<String, Object> h;
                    Throwable ex = csserror.getException();
                    errors_content[i] = h = new Hashtable<String, Object>();
                    h.put("Error", csserror);
                    h.put("CtxName", "nocontext");
                    h.put("CtxMsg", "");
                    h.put("ErrorMsg", ex.getMessage() == null ? "" : ex.getMessage());
                    h.put("ClassName", "unkownerror");
                    h.put("Type", csserror.getType());
                    if (ex instanceof FileNotFoundException) {
                        h.put("ClassName", "notfound");
                        h.put("ErrorMsg", this.ac.getMsg().getGeneratorString("not-found") + ": " + ex.getMessage());
                        continue;
                    }
                    if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex, h);
                        continue;
                    }
                    if (ex instanceof InvalidParamException) {
                        h.put("ClassName", "invalidparam");
                        h.put("ErrorMsg", this.queryReplace((String)h.get("ErrorMsg")));
                        continue;
                    }
                    if (ex instanceof IOException) {
                        String stringError = ex.toString();
                        h.put("CtxMsg", stringError);
                        h.put("ClassName", "io");
                        continue;
                    }
                    if (csserror instanceof CssErrorToken) {
                        CssErrorToken terror = (CssErrorToken)csserror;
                        h.put("ClassName", "errortoken");
                        String str = this.ac.getMsg().getErrorString("errortoken");
                        if (str == null) {
                            str = "Parse Error %s";
                        }
                        String[] params = new String[4];
                        params[0] = terror.getErrorToken();
                        params[1] = Integer.toString(terror.getLine());
                        StringBuilder sb = new StringBuilder();
                        boolean notfirst = false;
                        for (String t : terror.getExpected()) {
                            if (notfirst) {
                                sb.append(", ");
                            }
                            sb.append(t);
                        }
                        params[2] = sb.toString();
                        params[3] = terror.getSkippedString();
                        String[] msg_parts = str.split("%s", -1);
                        int j = 0;
                        sb.setLength(0);
                        sb.append(msg_parts[0]);
                        for (int k = 1; k < msg_parts.length; ++k) {
                            if (j < params.length) {
                                sb.append(params[j++]);
                            }
                            sb.append(msg_parts[k]);
                        }
                        h.put("ErrorMsg", this.queryReplace(sb.toString()));
                        continue;
                    }
                    h.put("ClassName", "unkownerror");
                    h.put("ErrorMsg", this.ac.getMsg().getErrorString("unknown") + " " + ex);
                    if (!(ex instanceof NullPointerException)) continue;
                    ex.printStackTrace();
                }
            }
            this.context.put("errors_content", errors_content);
        }
        catch (Exception e) {
            this.context.put("errors_content", errors_content);
            this.context.put("request", this.ac.getMsg().getGeneratorString("request"));
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void produceWarning() {
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                this.context.put("warnings_list", this.warnings.getWarnings());
            }
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    private void produceParseException(CssParseException error, Hashtable<String, Object> ht_error) {
        String ret;
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            ht_error.put("CtxName", "codeContext");
            StringBuilder buf = new StringBuilder();
            Iterator<CssSelectors> li = error.getContexts().iterator();
            while (li.hasNext()) {
                CssSelectors t = li.next();
                if (t == null) continue;
                buf.append(t);
                if (!li.hasNext()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                ht_error.put("CtxMsg", String.valueOf(buf));
            }
        } else {
            ht_error.put("CtxName", "nocontext");
        }
        ht_error.put("ClassName", "parse-error");
        String name = error.getProperty();
        if (name != null && StyleSheetGenerator.getURLProperty(name) != null && PropertiesLoader.getProfile(this.ac.getPropertyKey()).containsKey(name)) {
            Object _lnk;
            ht_error.put("link_before_parse_error", this.ac.getMsg().getGeneratorString("property"));
            CssVersion v = this.ac.getCssVersion();
            String lnk = v == CssVersion.CSS3 ? StyleSheetGenerator.getURLProperty("@url-base_css2.1") : (v == CssVersion.CSS1 ? StyleSheetGenerator.getURLProperty("@url-base_css2") : ((_lnk = this.context.get("cs_link")) == null ? "[error]" : _lnk.toString()));
            ht_error.put("link_value_parse_error", lnk + StyleSheetGenerator.getURLProperty(name));
            ht_error.put("link_name_parse_error", name);
        }
        if (error.getException() != null && error.getMessage() != null) {
            Exception ex;
            ret = error.isParseException() ? this.queryReplace(error.getMessage()) : ((ex = error.getException()) instanceof NumberFormatException ? this.ac.getMsg().getGeneratorString("invalid-number") : this.queryReplace(ex.getMessage()));
            if (error.getSkippedString() != null) {
                ht_error.put("span_class_parse_error", "skippedString");
                ht_error.put("span_value_parse_error", this.queryReplace(error.getSkippedString()));
            } else if (error.getExp() != null) {
                ret = ret + " : ";
                ht_error.put("span_class_parse_error", "exp");
                ht_error.put("span_value_parse_error", this.queryReplace(error.getExp().toString()));
            }
        } else {
            ret = this.ac.getMsg().getGeneratorString("unrecognize");
            ht_error.put("span_class_parse_error", "unrecognized");
            if (error.getSkippedString() != null) {
                ht_error.put("span_value_parse_error", this.queryReplace(error.getSkippedString()));
            } else if (error.getExp() != null) {
                ht_error.put("span_value_parse_error", this.queryReplace(error.getExp().toStringFromStart()));
            }
        }
        ht_error.put("ErrorMsg", ret);
    }

    private String queryReplace(String s) {
        if (!"xhtml.properties".equals(this.template_file)) {
            return s;
        }
        if (s != null) {
            int len = s.length();
            StringBuilder ret = new StringBuilder(len + 16);
            block9: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '&': {
                        ret.append("&amp;");
                        continue block9;
                    }
                    case '\'': {
                        ret.append("&#39;");
                        continue block9;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        continue block9;
                    }
                    case '<': {
                        ret.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        ret.append("&gt;");
                        continue block9;
                    }
                    case '\u201c': {
                        ret.append("<code>");
                        continue block9;
                    }
                    case '\u201d': {
                        ret.append("</code>");
                        continue block9;
                    }
                    default: {
                        ret.append(c);
                    }
                }
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    @Override
    public void print(PrintWriter out) {
        this.out = out;
        try {
            this.template.merge(this.context, out);
        }
        catch (Exception e) {
            new ErrorReportHTML(this.ac, this.title, "", e).print(out);
        }
        out.flush();
    }

    @Override
    public void desactivateError() {
        this.context.put("no_errors_report", Boolean.TRUE);
    }

    static {
        InputStream f;
        availableFormat = new Utf8Properties();
        try {
            f = StyleSheetGenerator.class.getResourceAsStream("format.properties");
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGeneratorHTML: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
        availablePropertiesURL = new Utf8Properties();
        try {
            f = StyleSheetGenerator.class.getResourceAsStream("urls.properties");
            availablePropertiesURL.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGeneratorHTML: couldn't load URLs properties ");
            System.err.println("  " + e.toString());
        }
        try {
            Velocity.setProperty("resource.loader", "classpath");
            Velocity.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
            Velocity.init();
            velocityToolManager = new ToolManager();
        }
        catch (Exception e) {
            System.err.println("Failed to initialize Velocity. Validator might not work as expected.");
        }
    }
}

