import os
import configparser
from PyQt5.Qt import QAction, QDialog, QVBoxLayout, QLabel, QPushButton, QComboBox, QApplication
from PyQt5.QtGui import QIcon, QColor, QPalette

class ThemeSwitcher:
    def __init__(self, gui):
        self.gui = gui
        icon_path = os.path.join(os.path.dirname(__file__), 'images', 'icon.png')
        self.action = QAction(QIcon(icon_path), 'Cambiar tema', gui)
        self.action.triggered.connect(self.show_dialog)
        gui.add_action(self.action)

    def show_dialog(self):
        dlg = QDialog(self.gui)
        dlg.setWindowTitle("Selector de temas")
        layout = QVBoxLayout()

        layout.addWidget(QLabel("Seleccioná un tema visual:"))
        selector = QComboBox()
        temas = self.obtener_temas_disponibles()
        selector.addItems(temas)
        layout.addWidget(selector)

        current_label = QLabel("Tema actual: ninguno")
        layout.addWidget(current_label)

        apply_btn = QPushButton("Aplicar tema")
        layout.addWidget(apply_btn)

        def aplicar_tema():
            tema = selector.currentText()
            current_label.setText(f"Tema actual: {tema}")
            self.aplicar_paleta(tema)
            self.aplicar_qss(tema)

        apply_btn.clicked.connect(aplicar_tema)
        dlg.setLayout(layout)
        dlg.exec_()

    def obtener_temas_disponibles(self):
        base = os.path.expanduser("~/.config/calibre/themes")
        if not os.path.exists(base):
            os.makedirs(base)
        return [f.split('.calibre-palette')[0] for f in os.listdir(base) if f.endswith('.calibre-palette')]

    def aplicar_paleta(self, nombre):
        path = os.path.expanduser(f"~/.config/calibre/themes/{nombre}.calibre-palette")
        config = configparser.ConfigParser()
        try:
            config.read(path)
            # Si el archivo tiene [dark], [light], [custom], usamos el nombre como sección
            section = nombre if nombre in config.sections() else config.sections()[0]
            palette_dict = dict(config.items(section))
            pal = QPalette()
            for role_name, hex_color in palette_dict.items():
                if '-disabled' in role_name:
                    continue
                try:
                    role = getattr(QPalette, role_name)
                    pal.setColor(role, QColor(hex_color))
                except AttributeError:
                    print(f"Rol desconocido: {role_name}")
            QApplication.instance().setPalette(pal)
        except Exception as e:
            print("Error al aplicar paleta calibre:", e)

    def aplicar_qss(self, nombre):
        path = os.path.join(os.path.dirname(__file__), 'resources', f'scrollbar-{nombre}.qss')
        try:
            with open(path, 'r') as f:
                style = f.read()
                QApplication.instance().setStyleSheet(style)
        except Exception as e:
            print("Error al aplicar QSS:", e)

