from calibre.customize import InterfaceActionBase

class InterfacePlugin(InterfaceActionBase):
    name = 'Theme Switcher'
    description = 'Selector de temas visuales para Calibre con soporte de paletas y QSS'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Dunhill'
    version = (1, 0, 0)
    minimum_calibre_version = (5, 0, 0)

    def load_interface(self, gui):
        from .action import ThemeSwitcher
        self.gui = gui
        self.action = ThemeSwitcher(gui)

