import os

def get_file_size_bytes(file_path):
    """Get file size in bytes, handling potential errors and cross-platform paths"""
    try:
        if not os.path.exists(file_path):
            return 0
        return os.path.getsize(file_path)
    except (OSError, IOError):
        return 0

def format_size(size_in_bytes):
    """Convert size in bytes to human readable format"""
    if size_in_bytes == 0:
        return "0B"
    units = ['B', 'KB', 'MB', 'GB', 'TB']
    i = 0
    while size_in_bytes >= 1024 and i < len(units)-1:
        size_in_bytes /= 1024.
        i += 1
    return f"{size_in_bytes:.1f}{units[i]}"
